/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.List;
import org.leandreck.endpoints.processor.model.TypeNode;

public class MethodNode {
    private final String name;
    private final String url;
    private final boolean ignored;
    private final TypeNode returnType;
    private final TypeNode paramType;
    private final List<String> httpMethods;

    public MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType) {
        this.name = name;
        this.url = url;
        this.ignored = ignored;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
        this.paramType = null;
    }

    public MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType, TypeNode paramType) {
        this.name = name;
        this.url = url;
        this.ignored = ignored;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
        this.paramType = paramType;
    }

    public TypeNode getReturnType() {
        return this.returnType;
    }

    public List<String> getHttpMethods() {
        return Collections.unmodifiableList(this.httpMethods);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getUrl() {
        return this.url;
    }

    public TypeNode getParamType() {
        return this.paramType;
    }
}

