/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.annotations.TypeScriptType;
import org.leandreck.endpoints.processor.model.TypeNode;

public class TypeNodeFactory {
    private static final Map<String, String> mappings = new HashMap<String, String>(20);
    private final Types typeUtils;
    private final Map<String, List<TypeNode>> createdChildren = new ConcurrentHashMap<String, List<TypeNode>>(200);

    public TypeNodeFactory(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    public TypeNode createTypeNode(VariableElement variableElement) {
        TypeScriptType typeScriptTypeAnnotation = variableElement.getAnnotation(TypeScriptType.class);
        TypeMirror typeMirror = variableElement.asType();
        String typeName = this.defineName(typeMirror, typeScriptTypeAnnotation);
        String fieldName = variableElement.getSimpleName().toString();
        List<TypeNode> children = this.createdChildren.get(typeName);
        if (children != null) {
            return this.initType(fieldName, typeName, typeMirror, typeScriptTypeAnnotation, children);
        }
        return this.initType(fieldName, typeName, typeMirror, typeScriptTypeAnnotation);
    }

    public TypeNode createTypeNode(TypeMirror typeMirror) {
        String typeName = this.defineName(typeMirror);
        String fieldName = "TYPE-ROOT";
        List<TypeNode> children = this.createdChildren.get(typeName);
        if (children != null) {
            return this.initType("TYPE-ROOT", typeName, typeMirror, null, children);
        }
        return this.initType("TYPE-ROOT", typeName, typeMirror, null);
    }

    private TypeNode initType(String fieldName, String typeName, TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation) {
        TypeNode newTypeNode;
        if (mappings.containsValue(typeName)) {
            newTypeNode = new TypeNode(fieldName, typeName);
        } else {
            TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
            String template = TypeNodeFactory.defineTemplate(typeElement, typeScriptTypeAnnotation);
            List<String> publicGetter = this.definePublicGetter(typeElement);
            List<TypeNode> children = this.defineChildren(typeElement, publicGetter);
            newTypeNode = new TypeNode(fieldName, typeName, template, children);
            this.createdChildren.put(typeName, children);
        }
        return newTypeNode;
    }

    private TypeNode initType(String fieldName, String typeName, TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation, List<TypeNode> children) {
        TypeElement typeElement = (TypeElement)this.typeUtils.asElement(typeMirror);
        String template = TypeNodeFactory.defineTemplate(typeElement, typeScriptTypeAnnotation);
        return new TypeNode(fieldName, typeName, template, children);
    }

    private List<String> definePublicGetter(TypeElement typeElement) {
        return ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(g -> g.getSimpleName().toString().startsWith("get") || g.getSimpleName().toString().startsWith("is")).filter(g -> g.getModifiers().contains((Object)Modifier.PUBLIC)).filter(g -> !g.getModifiers().contains((Object)Modifier.ABSTRACT)).map(g -> g.getSimpleName().toString()).collect(Collectors.toList());
    }

    private boolean filterVariableElements(VariableElement variableElement, List<String> publicGetter) {
        return publicGetter.stream().map(g -> g.toLowerCase().indexOf(variableElement.getSimpleName().toString().toLowerCase()) > -1).reduce(false, (a, b) -> a != false || b != false);
    }

    private List<TypeNode> defineChildren(TypeElement typeElement, List<String> publicGetter) {
        return ElementFilter.fieldsIn(typeElement.getEnclosedElements()).stream().filter(c -> c.getAnnotation(TypeScriptIgnore.class) == null).filter(c -> !c.getModifiers().contains((Object)Modifier.TRANSIENT)).filter(c -> this.filterVariableElements((VariableElement)c, publicGetter)).map(this::createTypeNode).collect(Collectors.toList());
    }

    private static String defineTemplate(TypeElement typeElement, TypeScriptType typeScriptTypeAnnotation) {
        String template = typeScriptTypeAnnotation == null || typeScriptTypeAnnotation.template().isEmpty() ? "/org/leandreck/endpoints/templates/typescript/interface.ftl" : typeScriptTypeAnnotation.template();
        return template;
    }

    private String defineName(TypeMirror typeMirror, TypeScriptType typeScriptTypeAnnotation) {
        String typeFromAnnotation;
        if (typeScriptTypeAnnotation != null && !"UNDEFINED".equals(typeFromAnnotation = this.defineTypeFromAnnotation(typeScriptTypeAnnotation))) {
            return typeFromAnnotation;
        }
        return this.defineName(typeMirror);
    }

    private String defineName(TypeMirror typeMirror) {
        List<Object> typeArguments;
        String mappedType = this.defineMappedType(typeMirror);
        if (!"UNDEFINED".equals(mappedType)) {
            return mappedType;
        }
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            typeArguments = declaredType.getTypeArguments();
        } else {
            typeArguments = Collections.emptyList();
        }
        try {
            String typeString;
            if (typeArguments.isEmpty()) {
                typeString = "I" + this.typeUtils.asElement(typeMirror).getSimpleName().toString();
            } else if (typeArguments.size() == 1) {
                TypeElement arrayType = (TypeElement)this.typeUtils.asElement((TypeMirror)typeArguments.get(0));
                typeString = "I" + arrayType.getSimpleName().toString() + "[]";
            } else if (typeArguments.size() == 2) {
                TypeElement keyType = (TypeElement)this.typeUtils.asElement((TypeMirror)typeArguments.get(0));
                TypeElement valueType = (TypeElement)this.typeUtils.asElement((TypeMirror)typeArguments.get(1));
                typeString = "{ [index: I" + keyType.getSimpleName().toString() + "]: I" + valueType.getSimpleName().toString() + " }";
            } else {
                typeString = "ERROR";
            }
            return typeString;
        }
        catch (NullPointerException nullex) {
            nullex.printStackTrace();
            return "ERROR";
        }
    }

    private String defineMappedType(TypeMirror typeMirror) {
        String mappedType;
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive() || TypeKind.VOID.equals((Object)kind)) {
            mappedType = mappings.get(kind.name());
        } else if (TypeKind.DECLARED.equals((Object)kind)) {
            String key = this.typeUtils.asElement(typeMirror).getSimpleName().toString();
            mappedType = mappings.get(key);
        } else {
            mappedType = null;
        }
        return mappedType == null ? "UNDEFINED" : mappedType;
    }

    private String defineTypeFromAnnotation(TypeScriptType annotation) {
        if (annotation != null && !annotation.value().isEmpty()) {
            return annotation.value();
        }
        return "UNDEFINED";
    }

    static {
        mappings.put("VOID", "Void");
        mappings.put("BYTE", "Number");
        mappings.put("Byte", "Number");
        mappings.put("SHORT", "Number");
        mappings.put("Short", "Number");
        mappings.put("INT", "Number");
        mappings.put("Integer", "Number");
        mappings.put("LONG", "Number");
        mappings.put("Long", "Number");
        mappings.put("FLOAT", "Number");
        mappings.put("Float", "Number");
        mappings.put("DOUBLE", "Number");
        mappings.put("Double", "Number");
        mappings.put("BigDecimal", "Number");
        mappings.put("BigInteger", "Number");
        mappings.put("CHAR", "String");
        mappings.put("Character", "String");
        mappings.put("String", "String");
        mappings.put("BOOLEAN", "Boolean");
        mappings.put("Boolean", "Boolean");
        mappings.put("Date", "Date");
    }
}

