/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.leandreck.endpoints.annotations.TypeScriptIgnore;
import org.leandreck.endpoints.processor.model.MethodNode;
import org.leandreck.endpoints.processor.model.TypeNode;
import org.leandreck.endpoints.processor.model.TypeNodeFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public class MethodNodeFactory {
    private final Types typeUtils;
    private final TypeNodeFactory typeNodeFactory;

    public MethodNodeFactory(Types typeUtils) {
        this.typeUtils = typeUtils;
        this.typeNodeFactory = new TypeNodeFactory(typeUtils);
    }

    public MethodNode createMethodNode(ExecutableElement methodElement) {
        RequestMapping requestMapping = methodElement.getAnnotation(RequestMapping.class);
        String name = MethodNodeFactory.defineName(methodElement);
        boolean ignored = MethodNodeFactory.defineIgnored(methodElement, requestMapping);
        if (ignored) {
            return new MethodNode(name, "", ignored, null, null);
        }
        String url = MethodNodeFactory.defineUrl(requestMapping);
        List<String> httpMethods = MethodNodeFactory.defineHttpMethods(requestMapping);
        TypeMirror returnMirror = methodElement.getReturnType();
        TypeNode returnType = this.typeNodeFactory.createTypeNode(returnMirror);
        return new MethodNode(name, url, ignored, httpMethods, returnType);
    }

    private static List<String> defineHttpMethods(RequestMapping requestMapping) {
        ArrayList<String> methods = new ArrayList<String>();
        if (requestMapping != null) {
            return Arrays.stream(requestMapping.method()).map(requestMethod -> requestMethod.toString().toLowerCase()).collect(Collectors.toList());
        }
        return methods;
    }

    private static boolean defineIgnored(ExecutableElement methodElement, RequestMapping requestMapping) {
        boolean hasIgnoreAnnotation = methodElement.getAnnotation(TypeScriptIgnore.class) != null;
        boolean hasRequestMappingAnnotation = requestMapping != null;
        boolean producesJson = hasRequestMappingAnnotation && Arrays.stream(requestMapping.produces()).map(value -> value.startsWith("application/json")).reduce(false, (a, b) -> a != false || b != false) != false;
        boolean isPublic = methodElement.getModifiers().contains((Object)Modifier.PUBLIC);
        return hasIgnoreAnnotation || !isPublic || !hasRequestMappingAnnotation || !producesJson;
    }

    private static String defineUrl(RequestMapping requestMapping) {
        String[] mappings;
        if (requestMapping != null && (mappings = requestMapping.value()).length > 0) {
            return mappings[0];
        }
        return "";
    }

    private static String defineName(ExecutableElement methodElement) {
        return methodElement.getSimpleName().toString();
    }
}

