/*
 * Decompiled with CFR 0.152.
 */
package org.leandreck.endpoints.processor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.leandreck.endpoints.processor.model.TypeNode;

public class MethodNode {
    private final String name;
    private final String url;
    private final boolean ignored;
    private final TypeNode returnType;
    private final List<String> httpMethods;

    public MethodNode() {
        this.name = "TestMethod";
        this.ignored = false;
        this.returnType = new TypeNode();
        this.returnType.getRealChildren().add(new TypeNode());
        this.returnType.getRealChildren().add(new TypeNode());
        this.returnType.getRealChildren().add(new TypeNode());
        this.returnType.getRealChildren().add(new TypeNode());
        this.httpMethods = Arrays.asList("GET", "POST");
        this.url = "/foobar";
    }

    public MethodNode(String name, String url, boolean ignored, List<String> httpMethods, TypeNode returnType) {
        this.name = name;
        this.url = url;
        this.ignored = ignored;
        this.returnType = returnType;
        this.httpMethods = httpMethods;
    }

    public TypeNode getReturnType() {
        return this.returnType;
    }

    public List<String> getHttpMethods() {
        return Collections.unmodifiableList(this.httpMethods);
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getUrl() {
        return this.url;
    }
}

