/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.net.URI;
import javax.xml.namespace.QName;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.ImmutableTerm;
import org.ldp4j.application.vocabulary.Term;

public final class RDF
extends AbstractImmutableVocabulary<ImmutableTerm> {
    private static final long serialVersionUID = -1616871929205422837L;
    public static final String NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String NS_PREFIX = "rdf";
    public static final Term TYPE;
    public static final Term FIRST;
    public static final Term REST;
    public static final Term VALUE;
    public static final Term SUBJECT;
    public static final Term PREDICATE;
    public static final Term OBJECT;
    public static final Term XML_LITERAL;
    public static final Term PROPERTY;
    public static final Term STATEMENT;
    public static final Term BAG;
    public static final Term SEQ;
    public static final Term ALT;
    public static final Term LIST;
    public static final Term NIL;
    private static final RDF VOCABULARY;

    private RDF() {
        super(ImmutableTerm.class, NAMESPACE, NS_PREFIX);
    }

    private static Term term(String localPart) {
        return new ImmutableTerm(VOCABULARY, localPart);
    }

    public static RDF getInstance() {
        return VOCABULARY;
    }

    public static Term[] values() {
        return RDF.getInstance().terms();
    }

    public static Term valueOf(String term) {
        return RDF.getInstance().fromName(term);
    }

    public static Term valueOf(QName term) {
        return RDF.getInstance().fromValue(term);
    }

    public static Term valueOf(URI term) {
        return RDF.getInstance().fromValue(term);
    }

    static {
        VOCABULARY = new RDF();
        TYPE = RDF.term("type");
        FIRST = RDF.term("first");
        REST = RDF.term("rest");
        VALUE = RDF.term("value");
        SUBJECT = RDF.term("subject");
        PREDICATE = RDF.term("predicate");
        OBJECT = RDF.term("object");
        XML_LITERAL = RDF.term("XMLLiteral");
        PROPERTY = RDF.term("Property");
        STATEMENT = RDF.term("Statement");
        BAG = RDF.term("Bag");
        SEQ = RDF.term("Seq");
        ALT = RDF.term("Alt");
        LIST = RDF.term("List");
        NIL = RDF.term("nil");
        VOCABULARY.initialize();
    }
}

