/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.ext;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class Generics {
    private Generics() {
    }

    static Class<?> getTypeParameter(Class<?> klass) {
        return Generics.getTypeParameter(klass, Object.class);
    }

    static <T> Class<T> getTypeParameter(Class<?> clazz, Class<? super T> bound) {
        Class<? super T> result;
        Type t = (Type)Preconditions.checkNotNull(clazz);
        while (t instanceof Class) {
            t = ((Class)t).getGenericSuperclass();
        }
        if (t instanceof ParameterizedType && (result = Generics.processParameterizedType(bound, (ParameterizedType)t)) != null) {
            return result;
        }
        throw new IllegalStateException("Cannot figure out type parameterization for " + clazz.getName());
    }

    protected static <T> Class<T> processParameterizedType(Class<? super T> bound, ParameterizedType parameterizedType) {
        for (Type param : parameterizedType.getActualTypeArguments()) {
            Class<? super T> cls = null;
            if (param instanceof Class) {
                cls = Generics.determineClass(bound, param);
            } else if (param instanceof TypeVariable) {
                cls = Generics.processTypeVariable(bound, (TypeVariable)param);
            }
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected static <T> Class<T> processTypeVariable(Class<? super T> bound, TypeVariable<?> typeVariable) {
        for (Type paramBound : typeVariable.getBounds()) {
            Class<? super T> cls;
            if (!(paramBound instanceof Class) || (cls = Generics.determineClass(bound, paramBound)) == null) continue;
            return cls;
        }
        return null;
    }

    private static <T> Class<T> determineClass(Class<? super T> bound, Type candidate) {
        Class cls;
        if (candidate instanceof Class && bound.isAssignableFrom(cls = (Class)candidate)) {
            return cls;
        }
        return null;
    }
}

