/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import org.ldp4j.application.data.ManagedIndividualId;

public final class RelativeIndividualId
implements Serializable {
    private static final long serialVersionUID = -6164598393401163488L;
    private final ManagedIndividualId parentId;
    private final URI path;

    private RelativeIndividualId(ManagedIndividualId parentId, URI path) {
        this.parentId = parentId;
        this.path = path;
    }

    public ManagedIndividualId parentId() {
        return this.parentId;
    }

    public URI path() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parentId, this.path});
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj.getClass() == this.getClass()) {
            RelativeIndividualId that = (RelativeIndividualId)obj;
            result = Objects.equal((Object)this.parentId, (Object)that.parentId) && Objects.equal((Object)this.path, (Object)that.path);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("parentId", (Object)this.parentId).add("path", (Object)this.path).toString();
    }

    public static RelativeIndividualId createId(ManagedIndividualId parentId, URI path) {
        Preconditions.checkNotNull((Object)parentId, (Object)"Parent identifier cannot be null");
        Preconditions.checkNotNull((Object)path, (Object)"Relative path cannot be null");
        return new RelativeIndividualId(parentId, path);
    }
}

