/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.LiteralVisitor;
import org.ldp4j.application.data.TypedLiteral;
import org.ldp4j.application.data.ValueVisitor;

final class ImmutableTypedLiteral<T extends Serializable>
implements TypedLiteral<T> {
    private static final long serialVersionUID = -7467201601402003544L;
    private final T value;
    private final URI type;

    ImmutableTypedLiteral(T value, URI type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitLiteral(this);
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitTypedLiteral(this);
    }

    @Override
    public URI type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TypedLiteral) {
            TypedLiteral that = (TypedLiteral)obj;
            result = Objects.equals(this.value, that.get()) && Objects.equals(this.type, that.type()) && !(obj instanceof LanguageLiteral);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("type", (Object)this.type).toString();
    }
}

