/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.ContextWriteSession;
import org.ldp4j.application.ContextWriteSessionReference;
import org.ldp4j.application.ContextWriteSessionState;
import org.ldp4j.application.ContextWriteSessionStateListener;
import org.ldp4j.application.WriteSessionCleaner;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.RuntimeDelegate;
import org.ldp4j.application.spi.ShutdownListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContext.class);
    private final RuntimeDelegate delegate = RuntimeDelegate.getInstance();
    private final Map<Long, ContextWriteSessionReference> references = Maps.newLinkedHashMap();
    private final Map<Long, Long> sessionOwner = Maps.newLinkedHashMap();
    private final Map<Long, Long> threadSession = Maps.newLinkedHashMap();
    private final ReferenceQueue<ContextWriteSession> referenceQueue = new ReferenceQueue();

    private ApplicationContext() {
        LOGGER.info("Initialized Application Context");
    }

    private ApplicationContextException failure(String fmt, Object ... args) {
        String message = String.format(fmt, args);
        LOGGER.error(message);
        return new ApplicationContextException(message);
    }

    private void setUpWriteSessionCleaner() {
        if (WriteSessionCleaner.isActive()) {
            return;
        }
        WriteSessionCleaner.launch(this.referenceQueue);
        this.delegate.registerShutdownListener(new ShutdownListener(){

            @Override
            public void engineShutdown() {
                WriteSessionCleaner.terminate();
            }
        });
    }

    private ContextWriteSession trackSession(ContextWriteSessionState state) {
        ContextWriteSession leakedSession = new ContextWriteSession(state);
        ContextWriteSessionReference reference = new ContextWriteSessionReference(leakedSession, state, this.referenceQueue);
        this.references.put(state.id(), reference);
        this.sessionOwner.put(state.id(), Thread.currentThread().getId());
        this.threadSession.put(Thread.currentThread().getId(), state.id());
        return leakedSession;
    }

    private synchronized void untrackSession(ContextWriteSessionState session) {
        long sessionId = session.id();
        long ownerId = this.sessionOwner.get(sessionId);
        this.references.remove(sessionId);
        this.sessionOwner.remove(sessionId);
        this.threadSession.remove(ownerId);
    }

    public synchronized WriteSession createSession() throws ApplicationContextException {
        if (this.threadSession.containsKey(Thread.currentThread().getId())) {
            throw this.failure("Thread already has an active session", new Object[0]);
        }
        if (this.delegate.isOffline()) {
            throw this.failure("The Application Engine is off-line", new Object[0]);
        }
        WriteSession nativeSession = this.delegate.createSession();
        if (nativeSession == null) {
            throw this.failure("Could not create native write session", new Object[0]);
        }
        this.setUpWriteSessionCleaner();
        return this.trackSession(new ContextWriteSessionState(nativeSession, new CleanerContextWriteSessionStateListener()));
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("delegate", (Object)this.delegate).add("references", this.references).add("sessionOwner", this.sessionOwner).add("threadSession", this.threadSession).toString();
    }

    public static ApplicationContext getInstance() {
        return ApplicationEngineSingleton.SINGLETON;
    }

    private static final class ApplicationEngineSingleton {
        private static final ApplicationContext SINGLETON = new ApplicationContext();

        private ApplicationEngineSingleton() {
        }
    }

    private final class CleanerContextWriteSessionStateListener
    implements ContextWriteSessionStateListener {
        private CleanerContextWriteSessionStateListener() {
        }

        @Override
        public void onDispose(ContextWriteSessionState state) {
            ApplicationContext.this.untrackSession(state);
        }
    }
}

