/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import java.io.Serializable;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ldp4j.application.data.DatatypeCohercionException;
import org.ldp4j.application.data.Datatypes;
import org.ldp4j.application.data.DateTimeLiteral;
import org.ldp4j.application.data.DurationLiteral;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.Literals;
import org.ldp4j.application.data.TimeUtils;
import org.ldp4j.application.data.TypedLiteral;
import org.ldp4j.commons.testing.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralsTest {
    private static Logger LOGGER = LoggerFactory.getLogger(LiteralsTest.class);
    private static final Date NOW = new Date();
    private DateTimeLiteral dateTime;

    @Before
    public void setUp() {
        this.dateTime = Literals.of((Date)NOW).dateTime();
    }

    @Test
    public void verifyIsUtilityClass() {
        MatcherAssert.assertThat((Object)Utils.isUtilityClass(Literals.class), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testNewLiteral$temporal$date() {
        this.checkNewLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toDate());
    }

    @Test
    public void testNewLiteral$temporal$sqlDate() {
        this.checkNewLiteral(Datatypes.DATE, TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toSqlDate());
    }

    @Test
    public void testNewLiteral$temporal$sqlTime() {
        this.checkNewLiteral(Datatypes.TIME, TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toSqlTime());
    }

    @Test
    public void testNewLiteral$temporal$calendar() {
        this.checkNewLiteral(this.nonGregorianCalendar());
    }

    @Test
    public void testNewLiteral$temporal$gregorianCalendar() {
        this.checkNewLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toGregorianCalendar());
    }

    @Test
    public void testNewLiteral$temporal$xmlGregorianCalendar() {
        this.checkNewLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toXMLGregorianCalendar());
    }

    @Test
    public void testNewLiteral$temporal$dateTime() {
        this.checkNewLiteral(this.dateTime.get());
    }

    @Test
    public void testNewLiteral$nonTemporal$serializable() {
        SerializableData data = new SerializableData();
        Literal literal = Literals.newLiteral((Object)data);
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.sameInstance((Object)data));
        if (literal instanceof TypedLiteral) {
            MatcherAssert.assertThat((Object)((TypedLiteral)literal).type(), (Matcher)Matchers.equalTo((Object)Datatypes.STRING));
        }
    }

    @Test
    public void testNewLiteral$nonTemporal$notSerializable() {
        NotSerializableData data = new NotSerializableData();
        Literal literal = Literals.newLiteral((Object)data);
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.equalTo((Object)data.toString()));
        if (literal instanceof TypedLiteral) {
            MatcherAssert.assertThat((Object)((TypedLiteral)literal).type(), (Matcher)Matchers.equalTo((Object)Datatypes.STRING));
        }
    }

    @Test
    public void testNewLiteral$duration$jodaDuration() {
        this.checkDurationLiteral(Literals.newLiteral((Object)this.jodaDuration()));
    }

    @Test
    public void testNewLiteral$duration$javaDuration() throws DatatypeConfigurationException {
        this.checkDurationLiteral(Literals.newLiteral((Object)this.javaDuration()));
    }

    private Duration jodaDuration() {
        return new Duration(1000L);
    }

    private javax.xml.datatype.Duration javaDuration() throws DatatypeConfigurationException {
        return DatatypeFactory.newInstance().newDuration(1000L);
    }

    @Test
    public void testNewTypedLiteral$duration$jodaDuration() {
        this.checkDurationLiteral(Literals.newTypedLiteral((Object)this.jodaDuration(), (URI)Datatypes.DURATION));
    }

    @Test
    public void testNewTypedLiteral$duration$javaDuration() throws DatatypeConfigurationException {
        this.checkDurationLiteral(Literals.newTypedLiteral((Object)this.javaDuration(), (URI)Datatypes.DURATION));
    }

    @Test
    public void testNewTypedLiteral$duration$string() throws DatatypeConfigurationException {
        this.checkDurationLiteral(Literals.newTypedLiteral((Object)this.javaDuration().toString(), (URI)Datatypes.DURATION));
    }

    @Test(expected=DatatypeCohercionException.class)
    public void testNewTypedLiteral$duration$cohercionFailure$string() throws DatatypeConfigurationException {
        this.checkDurationLiteral(Literals.newTypedLiteral((Object)"invalid", (URI)Datatypes.DURATION));
    }

    @Test(expected=DatatypeCohercionException.class)
    public void testNewTypedLiteral$duration$cohercionFailure$notString() throws DatatypeConfigurationException {
        this.checkDurationLiteral(Literals.newTypedLiteral((Object)new Date(), (URI)Datatypes.DURATION));
    }

    @Test
    public void testNewTypeLiteral$temporal$date() {
        this.checkNewTypeLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toDate());
    }

    @Test
    public void testNewTypeLiteral$temporal$sqlDate() {
        this.checkNewTypeLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toSqlDate());
    }

    @Test
    public void testNewTypeLiteral$temporal$sqlTime() {
        this.checkNewTypeLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toSqlTime());
    }

    @Test
    public void testNewTypeLiteral$temporal$calendar() {
        this.checkNewTypeLiteral(this.nonGregorianCalendar());
    }

    @Test
    public void testNewTypeLiteral$temporal$gregorianCalendar() {
        this.checkNewTypeLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toGregorianCalendar());
    }

    @Test
    public void testNewTypeLiteral$temporal$xmlGregorianCalendar() {
        this.checkNewTypeLiteral(TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toXMLGregorianCalendar());
    }

    @Test
    public void testNewTypeLiteral$temporal$dateTime() {
        this.checkNewTypeLiteral(this.dateTime.get());
    }

    @Test
    public void testNewTypeLiteral$temporal$string() {
        this.checkNewTypeLiteral(((DateTime)this.dateTime.get()).toString());
    }

    @Test
    public void testNewTypeLiteral$temporal$cohercionFailure$notString() {
        Object value = new Object();
        for (URI datatype : Datatypes.temporalDatatypes()) {
            LOGGER.debug("Trying to coherce not temporal object using {} ({}) with {}...", new Object[]{value, value.getClass().getName(), datatype});
            try {
                Literals.newTypedLiteral((Object)value, (URI)datatype);
                Assert.fail((String)"Should fail when cohercion is not possible");
            }
            catch (DatatypeCohercionException e) {
                LOGGER.debug("Failed as expected: {}", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testNewTypeLiteral$temporal$cohercionFailure$string() {
        String value = "invalid";
        for (URI datatype : Datatypes.temporalDatatypes()) {
            LOGGER.debug("Trying to coherce not temporal string using {} ({}) with {}...", new Object[]{value, value.getClass().getName(), datatype});
            try {
                Literals.newTypedLiteral((Object)value, (URI)datatype);
                Assert.fail((String)"Should fail when cohercion is not possible");
            }
            catch (DatatypeCohercionException e) {
                LOGGER.debug("Failed as expected: {}", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testNewTypedLiteral$nonTemporal$serializable() {
        SerializableData data = new SerializableData();
        URI datatype = URI.create("urn:my:datatype");
        TypedLiteral literal = Literals.newTypedLiteral((Object)data, (URI)datatype);
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.sameInstance((Object)data));
        MatcherAssert.assertThat((Object)literal.type(), (Matcher)Matchers.equalTo((Object)datatype));
    }

    @Test
    public void testNewTypedLiteral$nonTemporal$notSerializable() {
        NotSerializableData data = new NotSerializableData();
        URI datatype = URI.create("urn:my:datatype");
        TypedLiteral literal = Literals.newTypedLiteral((Object)data, (URI)datatype);
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.equalTo((Object)data.toString()));
        MatcherAssert.assertThat((Object)literal.type(), (Matcher)Matchers.equalTo((Object)Datatypes.STRING));
    }

    @Test
    public void testCreationFromXMLGregorianCalendar$customLocale() {
        XMLGregorianCalendar xgc = this.xmlGregorianCalendar();
        DateTimeLiteral dateTimeLiteral = Literals.of((XMLGregorianCalendar)xgc).withLocale(Locale.GERMANY).dateTime();
        MatcherAssert.assertThat((Object)this.dateTime, (Matcher)Matchers.equalTo((Object)dateTimeLiteral));
    }

    @Test
    public void testCreationFromXMLGregorianCalendar$customTimeZone() {
        XMLGregorianCalendar xgc = this.xmlGregorianCalendar();
        TimeZone timeZone = this.anotherTimeZone((DateTime)this.dateTime.get());
        DateTimeLiteral dateTimeLiteral = Literals.of((XMLGregorianCalendar)xgc).withTimeZone(timeZone).dateTime();
        MatcherAssert.assertThat((Object)this.dateTime, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)dateTimeLiteral)));
        MatcherAssert.assertThat((Object)((DateTime)this.dateTime.get()).compareTo((ReadableInstant)dateTimeLiteral.get()), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    public void testCreationFromXMLGregorianCalendar$customDefaults() throws DatatypeConfigurationException {
        XMLGregorianCalendar xgc = this.xmlGregorianCalendar();
        XMLGregorianCalendar nxgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar(this.anotherTimeZone((DateTime)this.dateTime.get())));
        DateTimeLiteral dateTimeLiteral = Literals.of((XMLGregorianCalendar)xgc).withDefaults(nxgc).dateTime();
        MatcherAssert.assertThat((Object)this.dateTime, (Matcher)Matchers.equalTo((Object)dateTimeLiteral));
    }

    @Test(expected=NullPointerException.class)
    public void testNewLanguageLiteral$nullValue() {
        Literals.newLanguageLiteral(null, (String)"not null");
    }

    @Test(expected=NullPointerException.class)
    public void testNewLanguageLiteral$nullLanguage() {
        Literals.newLanguageLiteral((String)"not null", null);
    }

    @Test
    public void testNewLanguage$regular() {
        LanguageLiteral nwl = Literals.newLanguageLiteral((String)"value", (String)"language");
        MatcherAssert.assertThat((Object)nwl, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)nwl.get(), (Matcher)Matchers.equalTo((Object)"value"));
        MatcherAssert.assertThat((Object)nwl.language(), (Matcher)Matchers.equalTo((Object)"language"));
    }

    @Test(expected=NullPointerException.class)
    public void testDuration$nullUnit() {
        Literals.duration((long)0L, null);
    }

    @Test
    public void testDuration$negativeDuration() {
        DurationLiteral nwl = Literals.duration((long)-1L, (TimeUnit)TimeUnit.DAYS);
        MatcherAssert.assertThat((Object)nwl, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)nwl.get(), (Matcher)Matchers.equalTo((Object)new Duration(-86400000L)));
    }

    @Test
    public void testDuration$regularDuration() {
        DurationLiteral nwl = Literals.duration((long)1L, (TimeUnit)TimeUnit.DAYS);
        MatcherAssert.assertThat((Object)nwl, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)nwl.get(), (Matcher)Matchers.equalTo((Object)new Duration(86400000L)));
    }

    @Test(expected=NullPointerException.class)
    public void testOf$duration$null() {
        Literals.of((javax.xml.datatype.Duration)null);
    }

    @Test
    public void testOf$duration$notNull() throws DatatypeConfigurationException {
        javax.xml.datatype.Duration dr = this.javaDuration();
        DurationLiteral literal = Literals.of((javax.xml.datatype.Duration)dr);
        MatcherAssert.assertThat((Object)literal, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.equalTo((Object)this.jodaDuration()));
    }

    @Test(expected=NullPointerException.class)
    public void testOf$string$nullValue() {
        Literals.of((String)null);
    }

    @Test
    public void testOf$string$notNull() {
        String data = "value";
        Literal literal = Literals.of((String)data);
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.equalTo((Object)data.toString()));
        if (literal instanceof TypedLiteral) {
            MatcherAssert.assertThat((Object)((TypedLiteral)literal).type(), (Matcher)Matchers.equalTo((Object)Datatypes.STRING));
        }
    }

    private void checkDurationLiteral(Object nl) {
        MatcherAssert.assertThat((Object)nl, (Matcher)Matchers.instanceOf(DurationLiteral.class));
        DurationLiteral literal = (DurationLiteral)nl;
        MatcherAssert.assertThat((Object)literal, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)literal.get(), (Matcher)Matchers.equalTo((Object)this.jodaDuration()));
    }

    private XMLGregorianCalendar xmlGregorianCalendar() {
        return TimeUtils.newInstance().from((DateTime)this.dateTime.get()).toXMLGregorianCalendar();
    }

    private Calendar nonGregorianCalendar() {
        Locale locale = null;
        for (Locale aLocale : Locale.getAvailableLocales()) {
            String unicodeLocaleType = aLocale.getUnicodeLocaleType("ca");
            if (unicodeLocaleType == null) continue;
            locale = aLocale;
            break;
        }
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(NOW);
        return calendar;
    }

    private TimeZone anotherTimeZone(DateTime dateTime) {
        String tzID = dateTime.getZone().getID();
        String[] tzIDs = TimeZone.getAvailableIDs();
        TimeZone timeZone = null;
        for (int i = 0; i < tzIDs.length; ++i) {
            if (tzIDs[i].equals(tzID)) continue;
            timeZone = TimeZone.getTimeZone(tzIDs[i]);
            break;
        }
        return timeZone;
    }

    private void checkNewLiteral(URI datatype, Object value) {
        LOGGER.debug("Trying literal creation using temporal value {} ({})...", value, (Object)value.getClass().getName());
        Literal literal = Literals.newLiteral((Object)value);
        LOGGER.debug("Got: {}", (Object)literal);
        MatcherAssert.assertThat((String)this.temporalAssertionMessage(value), (Object)literal, (Matcher)Matchers.instanceOf(DateTimeLiteral.class));
        MatcherAssert.assertThat((Object)((DateTimeLiteral)literal).type(), (Matcher)Matchers.equalTo((Object)datatype));
        MatcherAssert.assertThat((Object)((DateTimeLiteral)literal).get(), (Matcher)Matchers.equalTo((Object)this.dateTime.get()));
    }

    private void checkNewLiteral(Object value) {
        this.checkNewLiteral(Datatypes.DATE_TIME, value);
    }

    private void checkNewTypeLiteral(Object value) {
        for (URI datatype : Datatypes.temporalDatatypes()) {
            LOGGER.debug("Trying typed literal creation using {} ({}) with {}...", new Object[]{value, value.getClass().getName(), datatype});
            TypedLiteral literal = Literals.newTypedLiteral((Object)value, (URI)datatype);
            LOGGER.debug("Got: {}", (Object)literal);
            MatcherAssert.assertThat((String)this.temporalAssertionMessage(datatype, value), (Object)literal, (Matcher)Matchers.instanceOf(DateTimeLiteral.class));
            MatcherAssert.assertThat((Object)((DateTimeLiteral)literal).get(), (Matcher)Matchers.equalTo((Object)this.dateTime.get()));
        }
    }

    private String temporalAssertionMessage(Object value) {
        return String.format("An instance of temporal type %s should be wrapped with a DateTimeLiteral instance", value.getClass().getName());
    }

    private String temporalAssertionMessage(URI datatype, Object value) {
        return String.format("An instance of type %s should be wrapped with a DateTimeLiteral instance when using temporal datatype %s", value.getClass().getName(), datatype);
    }

    private static class NotSerializableData {
        private NotSerializableData() {
        }
    }

    private static class SerializableData
    implements Serializable {
        private static final long serialVersionUID = 6185440942019142775L;

        private SerializableData() {
        }
    }
}

