/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data.constraints;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.LocalIndividual;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.ManagedIndividualId;
import org.ldp4j.application.data.Name;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.RelativeIndividual;
import org.ldp4j.application.data.RelativeIndividualId;

final class ConstraintsHelper {
    private ConstraintsHelper() {
    }

    private static Individual<?, ?> createIndividual(DataSet dataSet, Serializable id) throws AssertionError {
        Individual<ManagedIndividualId, ManagedIndividual> newIndividual = null;
        if (id instanceof ManagedIndividualId) {
            newIndividual = dataSet.individual((ManagedIndividualId)id, ManagedIndividual.class);
        } else if (id instanceof URI) {
            newIndividual = ConstraintsHelper.createIndividualOfUri((URI)id, dataSet);
        } else if (id instanceof Name) {
            Name name = (Name)id;
            newIndividual = dataSet.individual(name, LocalIndividual.class);
        } else if (id instanceof RelativeIndividualId) {
            newIndividual = dataSet.individual((RelativeIndividualId)id, RelativeIndividual.class);
        } else {
            throw new AssertionError((Object)("Unsupported individual identifier type '" + id.getClass().getName() + "'"));
        }
        return newIndividual;
    }

    private static Individual<?, ?> createIndividualOfUri(URI uri, DataSet dataSet) {
        Individual<URI, ExternalIndividual> tmp = null;
        tmp = uri.isAbsolute() ? dataSet.individual(uri, ExternalIndividual.class) : dataSet.individual(uri, NewIndividual.class);
        return tmp;
    }

    private static void populate(DataSet dataSet, Collection<Serializable> individuals, ImmutableCollection.Builder<Individual<?, ?>> builder) {
        for (Serializable node : individuals) {
            Object individual = dataSet.individualOfId(node);
            if (individual == null) {
                individual = ConstraintsHelper.createIndividual(dataSet, node);
            }
            builder.add(individual);
        }
    }

    static Set<Individual<?, ?>> getOrCreateIndividuals(DataSet dataSet, Set<Serializable> individuals) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ConstraintsHelper.populate(dataSet, individuals, builder);
        return builder.build();
    }

    static List<Individual<?, ?>> getOrCreateIndividuals(DataSet dataSet, List<Serializable> individuals) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ConstraintsHelper.populate(dataSet, individuals, builder);
        return builder.build();
    }
}

