/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.Preconditions;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public final class TimeUtils {
    private final TimeZone timezone;
    private final Locale locale;
    private final XMLGregorianCalendar defaults;
    private final DatatypeFactory datatypeFactory;

    private TimeUtils(DatatypeFactory datatypeFactory, TimeZone timezone, Locale locale, XMLGregorianCalendar defaults) {
        this.datatypeFactory = datatypeFactory;
        this.timezone = timezone;
        this.locale = locale;
        this.defaults = defaults;
    }

    public TimeUtils withTimeZone(TimeZone timezone) {
        return new TimeUtils(this.datatypeFactory, timezone, this.locale, this.defaults);
    }

    public TimeUtils withLocale(Locale locale) {
        return new TimeUtils(this.datatypeFactory, this.timezone, locale, this.defaults);
    }

    public TimeUtils withDefaults(XMLGregorianCalendar defaults) {
        return new TimeUtils(this.datatypeFactory, this.timezone, this.locale, defaults);
    }

    public DateTimeConverter from(DateTime literal) {
        Preconditions.checkNotNull((Object)literal, (Object)"Literal cannot be null");
        return new DateTimeConverter(literal);
    }

    public DurationConverter from(Duration literal) {
        Preconditions.checkNotNull((Object)literal, (Object)"Literal cannot be null");
        return new DurationConverter(literal);
    }

    public static TimeUtils newInstance() {
        try {
            return new TimeUtils(DatatypeFactory.newInstance(), TimeZone.getDefault(), Locale.getDefault(), null);
        }
        catch (DatatypeConfigurationException e) {
            throw new AssertionError("Could not create factory", e);
        }
    }

    public final class DurationConverter {
        private final Duration duration;

        private DurationConverter(Duration literal) {
            this.duration = literal;
        }

        public long millis() {
            return this.duration.getMillis();
        }

        public long to(TimeUnit unit) {
            return unit.convert(this.millis(), TimeUnit.MILLISECONDS);
        }

        public javax.xml.datatype.Duration toDuration() {
            return TimeUtils.this.datatypeFactory.newDuration(this.millis());
        }
    }

    public final class DateTimeConverter {
        private final DateTime literal;

        private DateTimeConverter(DateTime literal) {
            this.literal = literal;
        }

        public long to(TimeUnit unit) {
            return unit.convert(this.toDate().getTime(), TimeUnit.MILLISECONDS);
        }

        public Date toDate() {
            return this.literal.toDate();
        }

        public java.sql.Date toSqlDate() {
            return new java.sql.Date(this.toDate().getTime());
        }

        public Time toSqlTime() {
            return new Time(this.toDate().getTime());
        }

        public Calendar toCalendar() {
            return this.literal.toCalendar(TimeUtils.this.locale);
        }

        public GregorianCalendar toGregorianCalendar() {
            return this.literal.toGregorianCalendar();
        }

        public XMLGregorianCalendar toXMLGregorianCalendar() {
            return TimeUtils.this.datatypeFactory.newXMLGregorianCalendar(this.toGregorianCalendar());
        }
    }
}

