/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ReflectPermission;
import java.net.URI;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.ShutdownListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeDelegate {
    private static final String DISABLE = "disable";
    public static final String APPLICATION_ENGINE_SPI_FINDER = "org.ldp4j.application.spi.finder";
    public static final String APPLICATION_ENGINE_SPI_CFG = "application-engine.properties";
    public static final String APPLICATION_ENGINE_SPI_PROPERTY = "org.ldp4j.application.spi.RuntimeDelegate";
    private static final String INSTANTIATE_ACTION = "instantiate";
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDelegate.class);
    private static final AtomicReference<RuntimeDelegate> CACHED_DELEGATE = new AtomicReference();
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS_PERMISSION = new ReflectPermission("suppressAccessChecks");

    protected RuntimeDelegate() {
    }

    private static RuntimeDelegate findDelegate() {
        RuntimeDelegate result = null;
        try {
            String delegateClassName;
            result = RuntimeDelegate.createRuntimeDelegateFromSPI();
            if (result == null) {
                result = RuntimeDelegate.createRuntimeDelegateFromConfigurationFile();
            }
            if (result == null && (delegateClassName = System.getProperty(APPLICATION_ENGINE_SPI_PROPERTY)) != null) {
                result = RuntimeDelegate.createRuntimeDelegateForClassName(delegateClassName);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Could not find application engine", (Throwable)ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuntimeDelegate createRuntimeDelegateFromConfigurationFile() {
        RuntimeDelegate result = null;
        File configFile = RuntimeDelegate.getConfigurationFile();
        if (configFile.canRead()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                Properties configProperties = new Properties();
                configProperties.load(is);
                String delegateClassName = configProperties.getProperty(APPLICATION_ENGINE_SPI_PROPERTY);
                if (delegateClassName != null) {
                    result = RuntimeDelegate.createRuntimeDelegateForClassName(delegateClassName);
                }
                if (delegateClassName == null) {
                    LOGGER.warn("Configuration file '{}' does not define a delegate class name", (Object)configFile.getAbsolutePath());
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Could not find runtime instance configuration file '{}'", (Object)configFile.getAbsolutePath(), (Object)e);
            }
            catch (IOException e) {
                LOGGER.warn("Could not load runtime instance configuration file '{}'", (Object)configFile.getAbsolutePath(), (Object)e);
            }
            finally {
                RuntimeDelegate.closeQuietly(is, "Could not close configuration properties");
            }
        }
        return result;
    }

    private static File getConfigurationFile() {
        return new File(new File(System.getProperty("java.home")), "lib" + File.separator + APPLICATION_ENGINE_SPI_CFG);
    }

    private static void closeQuietly(InputStream is, String message) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                LOGGER.warn(message, (Throwable)e);
            }
        }
    }

    private static RuntimeDelegate createRuntimeDelegateFromSPI() {
        if (!DISABLE.equalsIgnoreCase(System.getProperty(APPLICATION_ENGINE_SPI_FINDER))) {
            Iterator<RuntimeDelegate> iterator = ServiceLoader.load(RuntimeDelegate.class).iterator();
            while (iterator.hasNext()) {
                try {
                    return iterator.next();
                }
                catch (ServiceConfigurationError ex) {
                    LOGGER.error("Could not load {} service. Full stacktrace follows.", (Object)RuntimeDelegate.class.getCanonicalName(), (Object)ex);
                }
            }
        }
        return null;
    }

    private static RuntimeDelegate createRuntimeDelegateForClassName(String delegateClassName) {
        RuntimeDelegate result = null;
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            if (RuntimeDelegate.class.isAssignableFrom(delegateClass)) {
                Object impl = delegateClass.newInstance();
                result = (RuntimeDelegate)RuntimeDelegate.class.cast(impl);
            }
        }
        catch (ClassNotFoundException e) {
            RuntimeDelegate.handleFailure(delegateClassName, "find", e);
        }
        catch (InstantiationException e) {
            RuntimeDelegate.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        catch (IllegalAccessException e) {
            RuntimeDelegate.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        return result;
    }

    private static void handleFailure(String delegateClassName, String action, Exception failure) {
        LOGGER.warn("Could not {} delegate class {}", new Object[]{action, delegateClassName, failure});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeDelegate getInstance() {
        RuntimeDelegate result = CACHED_DELEGATE.get();
        if (result != null) {
            return result;
        }
        AtomicReference<RuntimeDelegate> atomicReference = CACHED_DELEGATE;
        synchronized (atomicReference) {
            result = CACHED_DELEGATE.get();
            if (result == null) {
                result = RuntimeDelegate.findDelegate();
                if (result == null) {
                    result = new DefaultRuntimeDelegate();
                }
                CACHED_DELEGATE.set(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(RuntimeDelegate delegate) {
        SecurityManager security = RuntimeDelegate.getSecurityManager();
        if (security != null) {
            security.checkPermission(SUPPRESS_ACCESS_CHECKS_PERMISSION);
        }
        AtomicReference<RuntimeDelegate> atomicReference = CACHED_DELEGATE;
        synchronized (atomicReference) {
            CACHED_DELEGATE.set(delegate);
        }
    }

    private static SecurityManager getSecurityManager() {
        return System.getSecurityManager();
    }

    public abstract boolean isOffline();

    public abstract WriteSession createSession() throws ApplicationContextException;

    public abstract ResourceSnapshotResolver createResourceResolver(URI var1, ReadSession var2);

    public abstract void registerShutdownListener(ShutdownListener var1);

    private static class DefaultRuntimeDelegate
    extends RuntimeDelegate {
        private DefaultRuntimeDelegate() {
        }

        @Override
        public WriteSession createSession() throws ApplicationContextException {
            throw new ApplicationContextException("No runtime delegate found");
        }

        @Override
        public boolean isOffline() {
            return true;
        }

        @Override
        public ResourceSnapshotResolver createResourceResolver(URI canonicalBase, ReadSession session) {
            return new NullResourceSnapshotResolver();
        }

        @Override
        public void registerShutdownListener(ShutdownListener listener) {
        }

        private static final class NullResourceSnapshotResolver
        implements ResourceSnapshotResolver {
            private NullResourceSnapshotResolver() {
            }

            @Override
            public URI resolve(ResourceSnapshot resource) {
                return null;
            }

            @Override
            public ResourceSnapshot resolve(URI endpoint) {
                return null;
            }
        }
    }
}

