/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.spi;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.ReflectPermission;
import java.net.URI;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import mockit.Mock;
import mockit.MockUp;
import mockit.Mocked;
import mockit.integration.junit4.JMockit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.session.ReadSession;
import org.ldp4j.application.session.ResourceSnapshot;
import org.ldp4j.application.session.WriteSession;
import org.ldp4j.application.spi.AbstractRuntimeDelegate;
import org.ldp4j.application.spi.CustomRuntimeDelegate;
import org.ldp4j.application.spi.HiddenRuntimeDelegate;
import org.ldp4j.application.spi.NotRuntimeDelegate;
import org.ldp4j.application.spi.ResourceSnapshotResolver;
import org.ldp4j.application.spi.RuntimeDelegate;

@RunWith(value=JMockit.class)
public class RuntimeDelegateTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder(new File("target/"));
    @Mocked
    URI canonicalBase;
    @Mocked
    URI endpoint;
    @Mocked
    WriteSession session;
    @Mocked
    ResourceSnapshot snapshot;

    private RuntimeDelegate sut() {
        RuntimeDelegate instance = RuntimeDelegate.getInstance();
        MatcherAssert.assertThat((Object)instance, (Matcher)Matchers.notNullValue());
        return instance;
    }

    private void verifyIsDefault(RuntimeDelegate sut) {
        MatcherAssert.assertThat(sut.getClass().getEnclosingClass(), (Matcher)Matchers.equalTo(RuntimeDelegate.class));
        MatcherAssert.assertThat((Object)sut.getClass().getSimpleName(), (Matcher)Matchers.equalTo((Object)"DefaultRuntimeDelegate"));
    }

    private boolean hasReflectionPermission(List<Permission> perms) {
        boolean found = false;
        for (Permission p : perms) {
            if (!(p instanceof ReflectPermission)) continue;
            found = true;
        }
        return found;
    }

    private File extensionConfigFile(String fileName) {
        File file = new File("src/test/resources/extensions/" + fileName);
        MatcherAssert.assertThat((Object)file.canRead(), (Matcher)Matchers.equalTo((Object)true));
        return file;
    }

    @Before
    public void setUp() {
        System.clearProperty("org.ldp4j.application.spi.RuntimeDelegate");
        System.setProperty("org.ldp4j.application.spi.finder", "disable");
        RuntimeDelegate.setInstance(null);
    }

    @After
    public void tearDown() {
        System.clearProperty("org.ldp4j.application.spi.RuntimeDelegate");
        System.clearProperty("org.ldp4j.application.spi.finder");
    }

    @Test
    public void testGetInstance$cacheWorks() throws Exception {
        RuntimeDelegate sut1 = this.sut();
        RuntimeDelegate sut2 = this.sut();
        MatcherAssert.assertThat((Object)sut2, (Matcher)Matchers.sameInstance((Object)sut1));
    }

    @Test
    public void testGetInstance$spi$enabled() throws Exception {
        System.clearProperty("org.ldp4j.application.spi.finder");
        new MockUp<ServiceLoader<RuntimeDelegate>>(){

            @Mock
            public Iterator<RuntimeDelegate> iterator() {
                return new Iterator<RuntimeDelegate>(){
                    int counter = 0;

                    @Override
                    public boolean hasNext() {
                        ++this.counter;
                        return this.counter < 3;
                    }

                    @Override
                    public RuntimeDelegate next() {
                        if (this.counter < 2) {
                            throw new ServiceConfigurationError("FAILURE");
                        }
                        return new CustomRuntimeDelegate();
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        MatcherAssert.assertThat((Object)this.sut(), (Matcher)Matchers.instanceOf(CustomRuntimeDelegate.class));
    }

    @Test
    public void testGetInstance$spi$disabled() throws Exception {
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$notReadable() throws Exception {
        final File file = new File("Not exists");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$ioException$notFound() throws Exception {
        final File file = new File("Not exists");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        new MockUp<File>(){

            @Mock
            public boolean canRead() {
                return true;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$ioException$readFailure() throws Exception {
        final File file = this.extensionConfigFile("empty.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        new MockUp<File>(){

            @Mock
            public boolean canRead() {
                return true;
            }
        };
        new MockUp<FileInputStream>(){

            @Mock
            public int read() throws IOException {
                throw new IOException("FAILURE");
            }

            @Mock
            public int read(byte[] bytes) throws IOException {
                throw new IOException("FAILURE");
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$ioException$closeFailure() throws Exception {
        final File file = this.extensionConfigFile("empty.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        new MockUp<FileInputStream>(){

            @Mock
            public void close() throws IOException {
                throw new IOException("FAILURE");
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$ioException$runtimeFailure() throws Exception {
        final File file = this.extensionConfigFile("empty.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        new MockUp<FileInputStream>(){

            @Mock
            public int read() throws IOException {
                throw new RuntimeException("FAILURE");
            }

            @Mock
            public int read(byte[] bytes) throws IOException {
                throw new RuntimeException("FAILURE");
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$empty() throws Exception {
        final File file = this.extensionConfigFile("empty.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$notFound() throws Exception {
        final File file = this.extensionConfigFile("not_found.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$notValid() throws Exception {
        final File file = this.extensionConfigFile("not_valid.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$notInstantiable() throws Exception {
        final File file = this.extensionConfigFile("not_instantiable.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$extension$privateConstructor() throws Exception {
        final File file = this.extensionConfigFile("private_constructor.cfg");
        new MockUp<RuntimeDelegate>(){

            @Mock
            File getConfigurationFile() {
                return file;
            }
        };
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$systemProperty$notFound() throws Exception {
        System.setProperty("org.ldp4j.application.spi.RuntimeDelegate", "not found");
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$systemProperty$notValid() throws Exception {
        System.setProperty("org.ldp4j.application.spi.RuntimeDelegate", NotRuntimeDelegate.class.getName());
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$systemProperty$notInstantiable() throws Exception {
        System.setProperty("org.ldp4j.application.spi.RuntimeDelegate", AbstractRuntimeDelegate.class.getName());
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$systemProperty$privateConstructor() throws Exception {
        System.setProperty("org.ldp4j.application.spi.RuntimeDelegate", HiddenRuntimeDelegate.class.getName());
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testGetInstance$systemProperty$valid() throws Exception {
        System.setProperty("org.ldp4j.application.spi.RuntimeDelegate", CustomRuntimeDelegate.class.getName());
        MatcherAssert.assertThat((Object)this.sut(), (Matcher)Matchers.instanceOf(CustomRuntimeDelegate.class));
    }

    @Test
    public void testSetInstance$null() throws Exception {
        RuntimeDelegate.setInstance(null);
        this.verifyIsDefault(this.sut());
    }

    @Test
    public void testSetInstance$securityManager$happyPath() throws Exception {
        class CustomSecurityManager
        extends SecurityManager {
            private final List<Permission> permissions = Lists.newArrayList();

            CustomSecurityManager() {
            }

            @Override
            public void checkPermission(Permission permission) {
                this.permissions.add(permission);
            }
        }
        final CustomSecurityManager manager = new CustomSecurityManager();
        new MockUp<RuntimeDelegate>(){
            {
            }

            @Mock
            public SecurityManager getSecurityManager() {
                return manager;
            }
        };
        RuntimeDelegate.setInstance(null);
        MatcherAssert.assertThat((Object)this.hasReflectionPermission(manager.permissions), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testSetInstance$securityManager$exceptionPath() throws Exception {
        class CustomSecurityManager
        extends SecurityManager {
            CustomSecurityManager() {
            }

            @Override
            public void checkPermission(Permission permission) {
                ReflectPermission rp;
                if (permission instanceof ReflectPermission && (rp = (ReflectPermission)permission).getName().equals("suppressAccessChecks")) {
                    throw new SecurityException("FAILURE");
                }
            }
        }
        final CustomSecurityManager manager = new CustomSecurityManager();
        new MockUp<RuntimeDelegate>(){

            @Mock
            public SecurityManager getSecurityManager() {
                return manager;
            }
        };
        try {
            RuntimeDelegate.setInstance((RuntimeDelegate)new CustomRuntimeDelegate());
            Assert.fail((String)"Should not be able to set instance if reflection is not allowed");
        }
        catch (SecurityException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"FAILURE"));
        }
    }

    @Test
    public void testIsOffline$defaultImplementation() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().isOffline(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCreateSession$defaultImplementation() throws Exception {
        try {
            this.sut().createSession();
        }
        catch (ApplicationContextException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void testCreateResourceResolver$defaultImplementation() throws Exception {
        MatcherAssert.assertThat((Object)this.sut().createResourceResolver(this.canonicalBase, (ReadSession)this.session), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testDefaultResourceSnapshotResolver$resolveSnapshot() throws Exception {
        ResourceSnapshotResolver resolver = this.sut().createResourceResolver(this.canonicalBase, (ReadSession)this.session);
        MatcherAssert.assertThat((Object)resolver.resolve(this.snapshot), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDefaultResourceSnapshotResolver$resolveURI() throws Exception {
        ResourceSnapshotResolver resolver = this.sut().createResourceResolver(this.canonicalBase, (ReadSession)this.session);
        MatcherAssert.assertThat((Object)resolver.resolve(this.endpoint), (Matcher)Matchers.nullValue());
    }
}

