/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadingTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadingTest.class);
    private static final ReferenceQueue<ThreadingTest> REFERENCE_QUEUE = new ReferenceQueue();

    @Test
    public void testTermination() throws Exception {
        DaemonThread.launch();
        Thread.sleep(5000L);
        DaemonThread.terminate();
        DaemonThread.instance.join();
    }

    private static class DaemonThread
    extends Thread {
        private static DaemonThread instance;
        private final AtomicBoolean terminate;

        private DaemonThread() {
            this.setPriority(10);
            this.setName("DaemonThread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.error("Cleaner thread unexpectedly died. Full stacktrace follows", e);
                    DaemonThread.launch();
                }
            });
            this.terminate = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            LOGGER.debug("Daemon started");
            while (!this.terminate.get()) {
                try {
                    Reference ref = REFERENCE_QUEUE.remove();
                    LOGGER.debug("Reference {} is now weakly reachable...", ref);
                }
                catch (InterruptedException e) {
                    LOGGER.debug("Daemon interrupted");
                }
            }
            LOGGER.debug("Daemon terminated");
        }

        static void launch() {
            LOGGER.debug("Launching...");
            instance = new DaemonThread();
            instance.start();
        }

        static void terminate() {
            LOGGER.debug("Terminating...");
            DaemonThread.instance.terminate.set(true);
            instance.interrupt();
        }
    }
}

