/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.net.URI;
import javax.xml.namespace.QName;
import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.ImmutableTerm;
import org.ldp4j.application.vocabulary.Term;

public final class LDP
extends AbstractImmutableVocabulary<ImmutableTerm> {
    private static final long serialVersionUID = -7172036547604166277L;
    public static final String NAMESPACE = "http://www.w3.org/ns/ldp#";
    public static final String NS_PREFIX = "ldp";
    public static final Term CONTAINS;
    public static final Term MEMBER;
    public static final Term MEMBERSHIP_RESOURCE;
    public static final Term HAS_MEMBER_RELATION;
    public static final Term IS_MEMBER_OF_RELATION;
    public static final Term INSERTED_CONTENT_RELATION;
    public static final Term CONSTRAINED_BY;
    public static final Term RESOURCE;
    public static final Term NON_RDF_SOURCE;
    public static final Term RDF_SOURCE;
    public static final Term CONTAINER;
    public static final Term BASIC_CONTAINER;
    public static final Term DIRECT_CONTAINER;
    public static final Term INDIRECT_CONTAINER;
    public static final Term MEMBER_SUBJECT;
    public static final Term PREFER_CONTAINMENT;
    public static final Term PREFER_EMPTY_CONTAINER;
    public static final Term PREFER_MINIMAL_CONTAINER;
    public static final Term PREFER_MEMBERSHIP;
    private static final LDP VOCABULARY;

    private LDP() {
        super(ImmutableTerm.class, NAMESPACE, NS_PREFIX);
    }

    private static Term term(String localPart) {
        return new ImmutableTerm(VOCABULARY, localPart);
    }

    public static LDP getInstance() {
        return VOCABULARY;
    }

    public static Term[] values() {
        return LDP.getInstance().terms();
    }

    public static Term valueOf(String term) {
        return LDP.getInstance().fromValue(term);
    }

    public static Term valueOf(QName term) {
        return LDP.getInstance().fromValue(term);
    }

    public static Term valueOf(URI term) {
        return LDP.getInstance().fromValue(term);
    }

    static {
        VOCABULARY = new LDP();
        CONTAINS = LDP.term("contains");
        MEMBER = LDP.term("member");
        MEMBERSHIP_RESOURCE = LDP.term("membershipResource");
        HAS_MEMBER_RELATION = LDP.term("hasMemberRelation");
        IS_MEMBER_OF_RELATION = LDP.term("isMemberOfRelation");
        INSERTED_CONTENT_RELATION = LDP.term("insertedContentRelation");
        CONSTRAINED_BY = LDP.term("constrainedBy");
        RESOURCE = LDP.term("Resource");
        NON_RDF_SOURCE = LDP.term("NonRDFSource");
        RDF_SOURCE = LDP.term("RDFSource");
        CONTAINER = LDP.term("Container");
        BASIC_CONTAINER = LDP.term("BasicContainer");
        DIRECT_CONTAINER = LDP.term("DirectContainer");
        INDIRECT_CONTAINER = LDP.term("IndirectContainer");
        MEMBER_SUBJECT = LDP.term("MemberSubject");
        PREFER_CONTAINMENT = LDP.term("PreferContainment");
        PREFER_EMPTY_CONTAINER = LDP.term("PreferEmptyContainer");
        PREFER_MINIMAL_CONTAINER = LDP.term("PreferMinimalContainer");
        PREFER_MEMBERSHIP = LDP.term("PreferMembership");
        VOCABULARY.initialize();
    }
}

