/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import org.ldp4j.application.vocabulary.AbstractImmutableVocabulary;
import org.ldp4j.application.vocabulary.CannotAdaptClassesException;
import org.ldp4j.application.vocabulary.Term;
import org.ldp4j.application.vocabulary.TermUtils;
import org.ldp4j.application.vocabulary.TypeAdapter;
import org.ldp4j.application.vocabulary.Vocabulary;

public class ImmutableTerm
implements Term {
    private static final long serialVersionUID = 6842492155071877731L;
    private static final int HASH_CODE_SALT = 19;
    private final int ordinal;
    private final String name;
    private final AbstractImmutableVocabulary<? extends ImmutableTerm> vocabulary;
    private final String entityName;

    public ImmutableTerm(AbstractImmutableVocabulary<? extends ImmutableTerm> vocabulary, String entityName) {
        this.vocabulary = vocabulary;
        this.entityName = entityName;
        this.name = TermUtils.toTermName(entityName);
        this.ordinal = vocabulary.reserveTermName(this.name);
        vocabulary.registerTerm(this);
    }

    @Override
    public final int ordinal() {
        return this.ordinal;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final String entityName() {
        return this.entityName;
    }

    @Override
    public final String qualifiedEntityName() {
        return this.vocabulary.getNamespace() + this.entityName;
    }

    public final Vocabulary<? extends ImmutableTerm> getDeclaringVocabulary() {
        return this.vocabulary;
    }

    public <V> V as(Class<? extends V> valueClass) {
        try {
            return TypeAdapter.adapt(this, valueClass);
        }
        catch (CannotAdaptClassesException e) {
            throw new UnsupportedOperationException("Class '" + this.getClass().getCanonicalName() + " cannot be transformed to '" + valueClass.getCanonicalName() + "'", e);
        }
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return super.hashCode() * 19;
    }

    protected final Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return this.qualifiedEntityName();
    }

    @Override
    public int compareTo(Term other) {
        ImmutableTerm self = this;
        if (self.getClass() != other.getClass() && self.getDeclaringVocabulary() != other.getDeclaringVocabulary()) {
            throw new ClassCastException();
        }
        return self.ordinal - other.ordinal();
    }
}

