/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.vocabulary;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.ldp4j.application.vocabulary.CannotAdaptClassesException;
import org.ldp4j.application.vocabulary.ImmutableTerm;
import org.ldp4j.application.vocabulary.TermUtils;
import org.ldp4j.application.vocabulary.TypeAdapter;
import org.ldp4j.application.vocabulary.Vocabulary;

public abstract class AbstractImmutableVocabulary<T extends ImmutableTerm>
implements Vocabulary<T> {
    private static final long serialVersionUID = -6913490730122202939L;
    private final UUID id = UUID.randomUUID();
    private final String namespace;
    private final String prefix;
    private final Class<T> termClass;
    private final Map<String, Integer> nameOrdinal = new HashMap<String, Integer>();
    private final SortedMap<Integer, T> terms = new TreeMap<Integer, T>();
    private int ordinal = -1;
    private Status status = Status.INITIALIZING;

    public AbstractImmutableVocabulary(Class<T> clazz, String namespace, String prefix) {
        this.termClass = clazz;
        this.namespace = namespace;
        this.prefix = prefix;
    }

    private void checkStatus(Status status) {
        if (!this.status.equals((Object)status)) {
            throw new IllegalStateException(status.getFailure(this.namespace));
        }
    }

    private void checkInitializationPrecondition(boolean precondition, String message, Object ... args) {
        if (!precondition) {
            String failureHeader = String.format("Vocabulary '%s' (%s) initialization failure: ", this.namespace, this.getClass().getCanonicalName());
            throw new IllegalArgumentException(failureHeader.concat(String.format(message, args)));
        }
    }

    public final UUID getId() {
        return this.id;
    }

    @Override
    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public final String getPreferredPrefix() {
        return this.prefix;
    }

    @Override
    public final T[] terms() {
        this.checkStatus(Status.INITIALIZED);
        ImmutableTerm[] array = (ImmutableTerm[])Array.newInstance(this.termClass, this.ordinal);
        return this.terms.values().toArray(array);
    }

    @Override
    public final int size() {
        this.checkStatus(Status.INITIALIZED);
        return this.ordinal;
    }

    @Override
    public final T fromName(String name) {
        this.checkStatus(Status.INITIALIZED);
        if (name == null) {
            throw new IllegalArgumentException("Object 'name' cannot be null");
        }
        Integer termOrdinal = this.nameOrdinal.get(name);
        if (termOrdinal != null) {
            return (T)((ImmutableTerm)this.terms.get(termOrdinal));
        }
        return null;
    }

    @Override
    public T fromOrdinal(int ordinal) {
        this.checkStatus(Status.INITIALIZED);
        if (ordinal < 0 || this.ordinal <= ordinal) {
            throw new IndexOutOfBoundsException("No term available with ordinal '" + ordinal + "'");
        }
        return (T)((ImmutableTerm)this.terms.get(ordinal));
    }

    @Override
    public final <V> T fromValue(V value) {
        this.checkStatus(Status.INITIALIZED);
        try {
            TypeAdapter<T, ?> adapter = TypeAdapter.createAdapter(this.termClass, value.getClass());
            for (ImmutableTerm candidate : this.terms.values()) {
                if (!value.equals(adapter.adapt(candidate))) continue;
                return (T)candidate;
            }
            return null;
        }
        catch (CannotAdaptClassesException e) {
            throw new UnsupportedOperationException("Class '" + this.termClass.getCanonicalName() + " cannot be transformed to '" + value.getClass().getCanonicalName() + "'", e);
        }
    }

    @Override
    public final Iterator<T> iterator() {
        this.checkStatus(Status.INITIALIZED);
        final Iterator<T> iterator = this.terms.values().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return (ImmutableTerm)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported");
            }
        };
    }

    protected final int reserveTermName(String name) {
        this.checkStatus(Status.INITIALIZING);
        this.checkInitializationPrecondition(TermUtils.isValidTermName(name), "Object '%s' is not a valid term name", name);
        this.checkInitializationPrecondition(!this.nameOrdinal.containsKey(name), "Term '%s' has been already reserved", name);
        this.nameOrdinal.put(name, ++this.ordinal);
        return this.ordinal;
    }

    protected final <S extends ImmutableTerm> void registerTerm(S term) {
        this.checkStatus(Status.INITIALIZING);
        this.checkInitializationPrecondition(this.nameOrdinal.containsKey(term.name()), "Term '%s' has not been reserved", term.name());
        this.checkInitializationPrecondition(term.ordinal() >= 0 && term.ordinal() <= this.ordinal, "invalid ordinal '%d' for reserved name '%s'", term.ordinal(), term.name());
        this.terms.put(term.ordinal(), this.termClass.cast(term));
    }

    protected final void initialize() {
        this.checkStatus(Status.INITIALIZING);
        if (this.terms.size() != this.nameOrdinal.size()) {
            throw new IllegalStateException(String.format("Vocabulary '%s' (%s) initialization failure: not all reserved names have been registered", this.namespace, this.getClass().getCanonicalName()));
        }
        this.status = Status.INITIALIZED;
    }

    private static enum Status {
        INITIALIZING("is already initialized"),
        INITIALIZED("has not been initialized properly");

        private final String explanation;

        private Status(String explanation) {
            this.explanation = explanation;
        }

        String getFailure(String namespace) {
            return "Vocabulary '" + namespace + "' " + this.explanation;
        }
    }
}

