/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ReflectPermission;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.ldp4j.application.ApplicationContextException;
import org.ldp4j.application.session.WriteSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeDelegate {
    private static final String DISABLE = "disable";
    public static final String APPLICATION_ENGINE_SPI_FINDER = "org.ldp4j.application.spi.finder";
    public static final String APPLICATION_ENGINE_SPI_CFG = "application-engine.properties";
    public static final String APPLICATION_ENGINE_SPI_PROPERTY = "org.ldp4j.application.spi.RuntimeDelegate";
    private static final String INSTANTIATE_ACTION = "instantiate";
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDelegate.class);
    private static final AtomicReference<RuntimeDelegate> CACHED_DELEGATE = new AtomicReference();
    private static final ReflectPermission SUPPRESS_ACCESS_CHECKS_PERMISSION = new ReflectPermission("suppressAccessChecks");

    protected RuntimeDelegate() {
    }

    private static RuntimeDelegate findDelegate() {
        try {
            String delegateClassName;
            RuntimeDelegate result = RuntimeDelegate.createRuntimeDelegateFromSPI();
            if (result == null) {
                result = RuntimeDelegate.createRuntimeDelegateFromConfigurationFile();
            }
            if (result == null && (delegateClassName = System.getProperty(APPLICATION_ENGINE_SPI_PROPERTY)) != null) {
                result = RuntimeDelegate.createRuntimeDelegateForClassName(delegateClassName);
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not find application engine", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuntimeDelegate createRuntimeDelegateFromConfigurationFile() {
        RuntimeDelegate result = null;
        File configFile = RuntimeDelegate.getConfigurationFile();
        if (configFile.canRead()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(configFile);
                Properties configProperties = new Properties();
                configProperties.load(is);
                String delegateClassName = configProperties.getProperty(APPLICATION_ENGINE_SPI_PROPERTY);
                if (delegateClassName != null) {
                    result = RuntimeDelegate.createRuntimeDelegateForClassName(delegateClassName);
                }
                if (delegateClassName == null && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Configuration file '" + configFile.getAbsolutePath() + "' does not define a delegate class name");
                }
            }
            catch (FileNotFoundException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Could not find runtime instance configuration file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
                }
            }
            catch (IOException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not load runtime instance configuration file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
                }
            }
            finally {
                RuntimeDelegate.closeQuietly(is, "Could not close configuration properties");
            }
        }
        return result;
    }

    private static File getConfigurationFile() {
        return new File(new File(System.getProperty("java.home")), "lib" + File.separator + APPLICATION_ENGINE_SPI_CFG);
    }

    private static void closeQuietly(InputStream is, String message) {
        block3: {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn(message, (Throwable)e);
                }
            }
        }
    }

    private static RuntimeDelegate createRuntimeDelegateFromSPI() {
        if (!DISABLE.equalsIgnoreCase(System.getProperty(APPLICATION_ENGINE_SPI_FINDER))) {
            try {
                Iterator<RuntimeDelegate> i$ = ServiceLoader.load(RuntimeDelegate.class).iterator();
                if (i$.hasNext()) {
                    RuntimeDelegate delegate = i$.next();
                    return delegate;
                }
            }
            catch (ServiceConfigurationError ex) {
                LOGGER.error("Could not load " + RuntimeDelegate.class.getCanonicalName() + " service. Full stacktrace follows:", (Throwable)ex);
            }
        }
        return null;
    }

    private static RuntimeDelegate createRuntimeDelegateForClassName(String delegateClassName) {
        RuntimeDelegate result = null;
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            if (RuntimeDelegate.class.isAssignableFrom(delegateClass)) {
                Object impl = delegateClass.newInstance();
                result = (RuntimeDelegate)RuntimeDelegate.class.cast(impl);
            }
        }
        catch (ClassNotFoundException e) {
            RuntimeDelegate.handleFailure(delegateClassName, "find", e);
        }
        catch (InstantiationException e) {
            RuntimeDelegate.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        catch (IllegalAccessException e) {
            RuntimeDelegate.handleFailure(delegateClassName, INSTANTIATE_ACTION, e);
        }
        return result;
    }

    private static void handleFailure(String delegateClassName, String action, Exception failure) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Could not " + action + " delegate class " + delegateClassName, (Throwable)failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RuntimeDelegate getInstance() {
        RuntimeDelegate result = CACHED_DELEGATE.get();
        if (result != null) {
            return result;
        }
        AtomicReference<RuntimeDelegate> atomicReference = CACHED_DELEGATE;
        synchronized (atomicReference) {
            result = CACHED_DELEGATE.get();
            if (result == null) {
                result = RuntimeDelegate.findDelegate();
                if (result == null) {
                    result = new DefaultRuntimeDelegate();
                }
                CACHED_DELEGATE.set(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(RuntimeDelegate delegate) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SUPPRESS_ACCESS_CHECKS_PERMISSION);
        }
        AtomicReference<RuntimeDelegate> atomicReference = CACHED_DELEGATE;
        synchronized (atomicReference) {
            CACHED_DELEGATE.set(delegate);
        }
    }

    public abstract boolean isOffline();

    public abstract WriteSession createSession() throws ApplicationContextException;

    public abstract void terminateSession(WriteSession var1) throws ApplicationContextException;

    private static class DefaultRuntimeDelegate
    extends RuntimeDelegate {
        private static final String ERROR_MESSAGE = String.format("No implementation for class '%s' could be found", RuntimeDelegate.class.getName());

        private DefaultRuntimeDelegate() {
        }

        @Override
        public WriteSession createSession() {
            throw new UnsupportedOperationException(ERROR_MESSAGE);
        }

        @Override
        public boolean isOffline() {
            throw new UnsupportedOperationException(ERROR_MESSAGE);
        }

        @Override
        public void terminateSession(WriteSession session) throws ApplicationContextException {
            throw new UnsupportedOperationException(ERROR_MESSAGE);
        }
    }
}

