/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import java.io.Serializable;
import org.ldp4j.application.data.DataSet;
import org.ldp4j.application.data.ExternalIndividual;
import org.ldp4j.application.data.Individual;
import org.ldp4j.application.data.IndividualVisitor;
import org.ldp4j.application.data.LocalIndividual;
import org.ldp4j.application.data.ManagedIndividual;
import org.ldp4j.application.data.NewIndividual;
import org.ldp4j.application.data.RelativeIndividual;

final class IndividualFinder
implements IndividualVisitor {
    private final DataSet dataSet;
    private Individual<?, ?> found = null;

    IndividualFinder(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    <T extends Serializable> Individual<T, ?> findOrCreate(Individual<T, ?> individual) {
        individual.accept(this);
        return this.found;
    }

    @Override
    public void visitManagedIndividual(ManagedIndividual individual) {
        this.found = this.dataSet.individual(individual.id(), ManagedIndividual.class);
    }

    @Override
    public void visitLocalIndividual(LocalIndividual individual) {
        this.found = this.dataSet.individual(individual.id(), LocalIndividual.class);
    }

    @Override
    public void visitExternalIndividual(ExternalIndividual individual) {
        this.found = this.dataSet.individual(individual.id(), ExternalIndividual.class);
    }

    @Override
    public void visitRelativeIndividual(RelativeIndividual individual) {
        this.found = this.dataSet.individual(individual.id(), RelativeIndividual.class);
    }

    @Override
    public void visitNewIndividual(NewIndividual individual) {
        this.found = this.dataSet.individual(individual.id(), NewIndividual.class);
    }
}

