/*
 * Decompiled with CFR 0.152.
 */
package org.ldp4j.application.data;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import org.ldp4j.application.data.LanguageLiteral;
import org.ldp4j.application.data.Literal;
import org.ldp4j.application.data.LiteralVisitor;
import org.ldp4j.application.data.TypedLiteral;
import org.ldp4j.application.data.ValueVisitor;

final class ImmutableLiteral<T extends Serializable>
implements Literal<T> {
    private static final long serialVersionUID = 7931003982852019934L;
    private final T value;

    ImmutableLiteral(T value) {
        this.value = value;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitLiteral(this);
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void accept(LiteralVisitor visitor) {
        visitor.visitLiteral(this);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Literal) {
            Literal that = (Literal)obj;
            result = Objects.equals(this.value, that.get()) && !(obj instanceof TypedLiteral) && !(obj instanceof LanguageLiteral);
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).toString();
    }
}

