/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.netscape;

import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.netscape.NetscapeConnectionFactory;
import org.ldaptive.provider.netscape.NetscapeProviderConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;

public class NetscapeProvider
implements Provider<NetscapeProviderConfig> {
    private NetscapeProviderConfig config = new NetscapeProviderConfig();

    public ProviderConnectionFactory<NetscapeProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        if (cc.getUseStartTLS()) {
            throw new UnsupportedOperationException("startTLS is not supported");
        }
        LDAPConstraints constraints = this.config.getLDAPConstraints();
        if (constraints == null) {
            constraints = this.getDefaultLDAPConstraints(cc);
        }
        LDAPSocketFactory factory = this.config.getLDAPSocketFactory();
        if (cc.getUseSSL() && factory == null) {
            factory = this.getHostnameVerifierSocketFactory(cc);
        }
        return new NetscapeConnectionFactory(cc.getLdapUrl(), this.config, constraints, factory, (int)cc.getConnectTimeout(), (int)cc.getResponseTimeout());
    }

    protected LDAPSocketFactory getHostnameVerifierSocketFactory(ConnectionConfig cc) {
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        return new NetscapeLDAPSocketFactory(TLSSocketFactory.getHostnameVerifierFactory((SslConfig)cc.getSslConfig(), (String[])ldapUrl.getEntriesAsString()));
    }

    protected LDAPConstraints getDefaultLDAPConstraints(ConnectionConfig cc) {
        return new LDAPConstraints();
    }

    public NetscapeProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(NetscapeProviderConfig pc) {
        this.config = pc;
    }

    public NetscapeProvider newInstance() {
        return new NetscapeProvider();
    }

    private static class NetscapeLDAPSocketFactory
    implements LDAPSocketFactory {
        private final SocketFactory factory;

        public NetscapeLDAPSocketFactory(SocketFactory sf) {
            this.factory = sf;
        }

        public Socket makeSocket(String host, int port) throws LDAPException {
            try {
                return this.factory.createSocket(host, port);
            }
            catch (IOException e) {
                throw new LDAPException(e.getMessage());
            }
        }
    }
}

