/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.netscape;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSocketFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.netscape.NetscapeConnection;
import org.ldaptive.provider.netscape.NetscapeProviderConfig;

public class NetscapeConnectionFactory
extends AbstractProviderConnectionFactory<NetscapeProviderConfig> {
    public static final int LDAP_VERSION = 3;
    private final LDAPConstraints ldapConstraints;
    private final LDAPSocketFactory socketFactory;
    private final int connectTimeout;
    private final int timeLimit;

    public NetscapeConnectionFactory(String url, NetscapeProviderConfig config, LDAPConstraints constraints, LDAPSocketFactory factory, int cTimeout, int rTimeout) {
        super(url, (ProviderConfig)config);
        this.ldapConstraints = constraints;
        this.socketFactory = factory;
        this.connectTimeout = cTimeout;
        this.timeLimit = rTimeout;
    }

    protected NetscapeConnection createInternal(String url) throws LdapException {
        LdapURL ldapUrl = new LdapURL(url);
        NetscapeConnection conn = null;
        boolean closeConn = false;
        try {
            LDAPConnection lc = this.socketFactory != null ? new LDAPConnection(this.socketFactory) : new LDAPConnection();
            if (this.connectTimeout > 0) {
                lc.setConnectTimeout(this.connectTimeout);
            }
            conn = new NetscapeConnection(lc, (NetscapeProviderConfig)this.getProviderConfig());
            if (this.timeLimit > 0) {
                conn.setTimeLimit(this.timeLimit);
            }
            lc.connect(3, ldapUrl.getLastEntry().getHostname(), ldapUrl.getLastEntry().getPort(), null, null, this.ldapConstraints);
        }
        catch (LDAPException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e), ResultCode.valueOf((int)e.getLDAPResultCode()));
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }
}

