/*
 * Decompiled with CFR 0.152.
 */
package org.LatencyUtils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.LatencyUtils.PauseDetector;

public class SimplePauseDetector
extends PauseDetector {
    static final long DEFAULT_SleepInterval = 1000000L;
    static final long DEFAULT_PauseNotificationThreshold = 1000000L;
    static final int DEFAULT_NumberOfDetectorThreads = 3;
    static final boolean DEFAULT_Verbose = false;
    final long sleepInterval;
    final long pauseNotificationThreshold;
    final int numberOfDetectorThreads;
    final boolean verbose;
    final AtomicLong consensusLatestTime = new AtomicLong();
    volatile long stallTheadMask = 0L;
    volatile long stopThreadMask = 0L;
    SimplePauseDetectorThread[] detectors;

    public SimplePauseDetector(long sleepInterval, long pauseNotificationThreshold, int numberOfDetectorThreads) {
        this(sleepInterval, pauseNotificationThreshold, numberOfDetectorThreads, false);
    }

    public SimplePauseDetector(long sleepInterval, long pauseNotificationThreshold, int numberOfDetectorThreads, boolean verbose) {
        this.sleepInterval = sleepInterval;
        this.pauseNotificationThreshold = pauseNotificationThreshold;
        this.numberOfDetectorThreads = numberOfDetectorThreads;
        this.verbose = verbose;
        this.detectors = new SimplePauseDetectorThread[numberOfDetectorThreads];
        for (int i = 0; i < numberOfDetectorThreads; ++i) {
            this.detectors[i] = new SimplePauseDetectorThread(i);
            this.detectors[i].start();
        }
    }

    public SimplePauseDetector() {
        this(1000000L, 1000000L, 3, false);
    }

    @Override
    public void shutdown() {
        this.stopThreadMask = -1L;
        super.shutdown();
        LockSupport.parkNanos(10L * this.sleepInterval);
    }

    public void stallDetectorThreads(long threadNumberMask, long stallLength) {
        long savedMask = this.stallTheadMask;
        this.stallTheadMask = threadNumberMask;
        long startTime = System.nanoTime();
        long endTime = startTime + stallLength;
        long remainingTime = stallLength;
        do {
            if ((remainingTime = endTime - System.nanoTime()) <= 1000000L) continue;
            LockSupport.parkNanos(remainingTime);
        } while (remainingTime > 0L);
        this.stallTheadMask = savedMask;
    }

    class SimplePauseDetectorThread
    extends Thread {
        volatile long observedLasUpdateTime;
        final int threadNumber;
        final long threadMask;

        SimplePauseDetectorThread(int threadNumber) {
            if (threadNumber < 0 || threadNumber > 63) {
                throw new IllegalArgumentException("threadNumber must be between 0 and 63.");
            }
            this.threadNumber = threadNumber;
            this.threadMask = 1 << threadNumber;
            this.setDaemon(true);
            this.setName("SimplePauseDetectorThread_" + threadNumber);
        }

        @Override
        public void run() {
            long now;
            this.observedLasUpdateTime = SimplePauseDetector.this.consensusLatestTime.get();
            long prevNow = now = System.nanoTime();
            SimplePauseDetector.this.consensusLatestTime.compareAndSet(this.observedLasUpdateTime, now);
            long shortestObservedTimeAroundLoop = Long.MAX_VALUE;
            while ((SimplePauseDetector.this.stopThreadMask & this.threadMask) == 0L) {
                if (SimplePauseDetector.this.sleepInterval != 0L) {
                    LockSupport.parkNanos(SimplePauseDetector.this.sleepInterval);
                }
                while ((SimplePauseDetector.this.stallTheadMask & this.threadMask) != 0L) {
                }
                this.observedLasUpdateTime = SimplePauseDetector.this.consensusLatestTime.get();
                now = System.nanoTime();
                if (SimplePauseDetector.this.consensusLatestTime.compareAndSet(this.observedLasUpdateTime, now)) {
                    long hiccupTime;
                    long deltaTimeNs = now - this.observedLasUpdateTime;
                    long timeAroundLoop = now - prevNow;
                    if (timeAroundLoop < shortestObservedTimeAroundLoop) {
                        shortestObservedTimeAroundLoop = timeAroundLoop;
                    }
                    long l = hiccupTime = (hiccupTime = deltaTimeNs - shortestObservedTimeAroundLoop) < 0L ? 0L : hiccupTime;
                    if (hiccupTime > SimplePauseDetector.this.pauseNotificationThreshold) {
                        if (SimplePauseDetector.this.verbose) {
                            System.out.println("SimplePauseDetector thread " + this.threadNumber + ": sending pause notification message: pause of " + hiccupTime + " nsec detected at nanoTime: " + now + " (sleepInterval = " + SimplePauseDetector.this.sleepInterval + " , shortest time around loop = " + shortestObservedTimeAroundLoop + ")");
                        }
                        SimplePauseDetector.this.notifyListeners(hiccupTime, now);
                    }
                }
                prevNow = now;
            }
        }
    }
}

