/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.CatalanRule;
import org.languagetool.tools.StringTools;

public class ReflexiveVerbsRule
extends CatalanRule {
    private static final List<String> verbsPronominals = Arrays.asList("apoltronar", "rojar", "personar", "encaramallar", "desomplir", "delir", "fugar", "abacallanar", "abalan\u00e7ar", "ablenar", "aborrallonar", "abotifarrar", "abrinar", "abromar", "abstenir", "acagallonar", "acanyar", "acarcanyar", "acarnissar", "acatarrar", "aciutadanar", "aclocar", "acopar", "acorriolar", "adir", "adonar", "adormissar", "afal\u00b7lerar", "afarrossar", "afeccionar", "aferrallar", "aferrissar", "aferrussar", "agallinar", "agarbir", "agarrofar", "agemolir", "agenollar", "agotzonar", "aiguabarrejar", "allocar", "al\u00e7urar", "amatinar", "amelar", "amigar", "amoixir", "amoltonar", "amotar", "amullerar", "amunionar", "antullar", "aparroquianar", "aparroquiar", "aperduar", "apergaminar", "apiadar", "aponentar", "apropinquar", "apugonar", "arguellar", "arrapinyar", "arrasir", "arravatar", "arra\u00efmar", "arrepapar", "arrepenjar", "arrepetellar", "arrigolar", "arrodir", "arrogar", "arrossar", "arruar", "assemblar", "assocarrar", "atendar", "atenir", "atorrentar", "atrafegar", "atrevir", "avencar", "avidolar", "avinen\u00e7ar", "balbar", "balcar", "balir", "balmar", "bescomptar", "boirar", "boixar", "botinflar", "bromar", "cagaferrar", "candir", "capbaixar", "capmassar", "captenir", "cariar", "carnificar", "carpir", "coalitzar", "colltrencar", "collvinclar", "compenetrar", "condoldre", "condolir", "congraciar", "contor\u00e7ar", "contrapuntar", "cont\u00f2rcer", "corcorcar", "coresfor\u00e7ar", "cornuar", "corruixar", "crisalidar", "desafeccionar", "desalenar", "desamorar", "desaparroquiar", "desapassionar", "desaplegar", "desavenir", "desbocar", "descantar", "descarar", "descontrolar", "descovar", "desdubtar", "desempallegar", "desenrojolar", "desentossudir", "desfeinar", "desmemoriar", "desnodrir", "despondre", "despreocupar", "dessolidaritzar", "desteixinar", "desvagar", "desvergonyir", "desviure", "dignar", "embarbussar", "embascar", "embessonar", "embordeir", "embordir", "emborrascar", "emborrossar", "embotifarrar", "embotzegar", "embromallar", "embromar", "embroquerar", "emmainadar", "emmalurar", "emmalurir", "emmarar", "emmarranar", "emmatar", "emmigranyar", "emmorronar", "emmurriar", "empassar", "empassolar", "empegueir", "empenyalar", "empescar", "empillocar", "empinyar", "empiocar", "empitarrar", "emplomissar", "emplujar", "emportar", "encabotar", "encabritar", "encalmar", "encalostrar", "encelar", "encinglar", "encirar", "encistar", "enclaperar", "encolerir", "encordar", "encruar", "endoblir", "endur", "enfarfollar", "enfaristolar", "enfavar", "enfereir", "enferotgir", "enferritjar", "enfugir", "enfurrunyar", "enfutimar", "enfutismar", "engelabrir", "engolfar", "engorgar", "engripar", "enguerxinar", "enllagrimar", "enlleganyar", "enlleir", "ennavegar", "enneguitar", "enquistar", "enrinxar", "enseriosir", "ensobecar", "entonyinar", "entossudir", "entotsolar", "entreabaltir", "entrebadar", "entrebatre", "entrebesar", "entrecavalcar", "entredevorar", "entreferir", "entreforcar", "entrematar", "entremetre", "entremirar", "entrenyorar", "entresaludar", "entreseguir", "entresoldar", "entretocar", "entretzenar", "entrigar", "envidreir", "envidriar", "envolar", "enxautar", "esbafar", "esbafegar", "esbatussar", "esblamar", "esbojarrar", "esborneiar", "esbromar", "escabridar", "escamotar", "escanyellar", "escanyolir", "escanyussar", "escapolar", "escapolir", "escarcanyar", "escarramicar", "escarrassar", "escarxofar", "escatifenyar", "esconillar", "escorporar", "escullar", "escun\u00e7ar", "esfarinar", "esfetgegar", "esfor\u00e7ar", "esgargamellar", "esgatinyar", "esgolar", "esguimbar", "esllanguir", "esllavissar", "esperitar", "espitellar", "espitxar", "espollinar", "espoltrar", "esporcellar", "espotonar", "esprimatxar", "esquifir", "esquitllar", "estilar", "estritllar", "esvedellar", "esventegar", "esvomegar", "etiolar", "extralimitar", "extravasar", "extravenar", "gamar", "gaspar", "gatinyar", "gaubar", "gloriar", "grifar", "immiscir", "indigestar", "industriar", "innivar", "insolentar", "insurgir", "inveterar", "ir\u00e8ixer", "jactar", "juramentar", "lateritzar", "llufar", "malfiar", "malfixar", "migrolar", "mofar", "mullerar", "neulir", "obstinar", "octubrar", "olivar", "pellobrir", "pellpartir", "pelltrencar", "penedir", "penjolar", "pollar", "prosternar", "queixar", "querar", "querellar", "quillar", "ramificar", "rancurar", "realegrar", "rebel\u00b7lar", "rebordeir", "refiar", "repanxolar", "repapar", "repetellar", "reressagar", "resclosir", "ressagar", "ressentir", "revenjar", "salinar", "su\u00efcidar", "tinyar", "tolir", "transvestir", "traspostar", "trufar", "vanagloriar", "vanagloriejar", "vanar", "vantar", "vergonyar", "xautar");
    private static final Pattern VERB_AUTO = Pattern.compile("auto.+");
    private static final List<String> excepVerbsPronominals = Arrays.asList("delirar", "atendre", "escollir", "assolir", "autografiar", "automatitzar", "autoritzar");
    private static final List<String> verbsNoPronominals = Arrays.asList("baixar", "caure", "callar", "marxar", "albergar", "olorar", "seure");
    private static final List<String> verbsNoPronominalsImpersonals = Arrays.asList("caure", "callar", "marxar", "olorar");
    private static final List<String> verbsNoPronominalsImpersonals2 = Arrays.asList("t\u00e9mer", "albergar", "baixar");
    private static final List<String> excepVerbsNoPronominals = Arrays.asList("segar");
    private static final List<String> verbsMoviment = Arrays.asList("anar", "pujar", "venir");
    private static final List<String> excepVerbsMoviment = Arrays.asList("vendre");
    private static final List<String> verbsSovintAmbComplement = Arrays.asList("deixar", "fer", "veure", "costar");
    private static final List<String> verbsDeixarFer = Arrays.asList("deixar", "fer");
    private static final List<String> verbsPortarDur = Arrays.asList("portar", "dur");
    private static final List<String> verbsPotencialmentPronominals = Arrays.asList("abaixar", "abandonar", "abarrocar", "abellir", "abismar", "abissar", "ablamar", "ablanir", "abocar", "aboldronar", "abonan\u00e7ar", "abonar", "abonir", "abonyegar", "abordar", "abraonar", "abra\u00e7ar", "abrivar", "abroquerar", "abrusar", "absentar", "abstraure", "abstreure", "aburgesar", "acabar", "acalar", "acalorar", "acantonar", "acarrerar", "acastellanar", "acatalanar", "accelerar", "acetificar", "acidificar", "aclarir", "aclimatar", "aclivellar", "aclucar", "acoblar", "acollir", "acollonir", "acomiadar", "acomodar", "acomplexar", "acomplir", "aconductar", "aconsellar", "acontentar", "acopar", "acoquinar", "acordar", "acorruar", "acostar", "acostumar", "acotar", "acotxar", "acovardir", "acreditar", "acr\u00e9ixer", "acubar", "acubillar", "acudir", "acugular", "acuitar", "acular", "acumular", "acusar", "adaptar", "adargar", "adherir", "adjudicar", "adollar", "adolorir", "adondar", "adormir", "adossar", "adotzenar", "adre\u00e7ar", "adscriure", "adunar", "afalconar", "afanyar", "afartar", "afeblir", "afectar", "afermar", "aferrar", "afigurar", "afilar", "afilerar", "afiliar", "afillar", "afinar", "aflaquir", "afligir", "aflonjar", "afluixar", "afogar", "afollar", "afrancesar", "afrevolir", "afuar", "afusar", "agabellar", "agafar", "agarbar", "agarbonar", "agitar", "aglomerar", "aglutinar", "agombolar", "agostejar", "agradar", "agregar", "agremiar", "agreujar", "agrir", "agrisar", "agrumar", "aguantar", "aguditzar", "aigualir", "airejar", "aixecar", "aixoplugar", "ajaure", "aja\u00e7ar", "ajeure", "ajornalar", "ajudar", "ajuntar", "ajupir", "ajustar", "alabar", "alarmar", "alcalinitzar", "alcoholitzar", "alegrar", "alentir", "aliar", "alimentar", "alinear", "allarar", "allargar", "allargassar", "allerar", "alleugerir", "alleujar", "alliberar", "alligar", "allistar", "allitar", "allotjar", "allunyar", "alterar", "alzinar", "al\u00e7ar", "amagar", "amagrir", "amanerar", "amanir", "amansar", "amansir", "amassar", "ambientar", "americanitzar", "amistan\u00e7ar", "amistar", "amollar", "amorar", "amorosir", "amorrar", "amorriar", "amotinar", "amo\u00efnar", "amuntegar", "anastomitzar", "angoixar", "anguniejar", "animar", "anomenar", "anticipar", "apagar", "apaivagar", "apanyar", "aparellar", "apariar", "apartar", "apar\u00e8ixer", "apassionar", "apercebre", "apilotar", "apinyar", "apitrar", "aplanar", "apla\u00e7ar", "aplicar", "apocar", "apoderar", "aposentar", "apostar", "apostemar", "apregonar", "aprendre", "apressar", "aprimar", "aprofitar", "apropar", "apropiar", "aprovisionar", "aproximar", "apujar", "apuntalar", "aquedar", "aquietar", "aquilotar", "arborar", "arbrar", "arcar", "argollar", "aristocratitzar", "armar", "arquejar", "arraconar", "arramadar", "arrambar", "arramellar", "arranjar", "arrapar", "arraulir", "arrear", "arrecerar", "arredossar", "arreglar", "arrelar", "arremangar", "arremolinar", "arremorar", "arrenglerar", "arreplegar", "arrestar", "arribar", "arrimar", "arriscar", "arrissar", "arrodonir", "arromangar", "arrombollar", "arronsar", "arrossegar", "arrufar", "arrugar", "arru\u00efnar", "articular", "asfixiar", "assabentar", "assaonar", "assecar", "assegurar", "assentar", "assenyalar", "asserenar", "assessorar", "asseure", "assimilar", "associar", "assolar", "assolellar", "assossegar", "assotar", "astorar", "atabalar", "ataconar", "atalaiar", "atandar", "atansar", "atapeir", "atardar", "atavellar", "aterrir", "aterrossar", "atipar", "atiplar", "atonir", "atorrollar", "atracar", "atribolar", "atribuir", "atrinxerar", "atrofiar", "atropellar", "atrotinar", "aturar", "avalotar", "avan\u00e7ar", "avarar", "avariar", "avenir", "aventurar", "avergonyir", "avesar", "aviar", "aviciar", "avidar", "avivar", "avorrir", "a\u00efllar", "a\u00efrar", "badar", "balancejar", "balandrejar", "baldar", "banyar", "barallar", "barrejar", "basar", "basquejar", "bastar", "batre", "befar", "bellugar", "beneficiar", "bleir", "blocar", "bolcar", "bombar", "bonificar", "botir", "brindar", "brossar", "bufar", "buidar", "burocratitzar", "cabrejar", "cabussar", "cagar", "calar", "calmar", "cal\u00e7ar", "campar", "cansar", "cap", "capal\u00e7ar", "capbussar", "capficar", "capgirar", "captar", "captrencar", "caracteritzar", "caragirar", "carbonar", "carbonatar", "carbonitzar", "cardar", "cargolar", "carregar", "cartejar", "casar", "cascar", "cenyir", "cerciorar", "cicatritzar", "circumscriure", "clamar", "classificar", "clavar", "clivellar", "cloure", "coagular", "cobrir", "colar", "colgar", "colltor\u00e7ar", "collt\u00f2rcer", "colrar", "coltellejar", "col\u00b7lapsar", "col\u00b7legiar", "col\u00b7locar", "comanar", "combinar", "compadir", "compaginar", "compatir", "compensar", "complementar", "complexificar", "complicar", "complir", "compl\u00e0nyer", "compondre", "comportar", "comprendre", "comprimir", "comprometre", "compungir", "comunicar", "concentrar", "concertar", "conciliar", "concordar", "concretar", "condemnar", "condensar", "conduir", "confabular", "confederar", "confessar", "confinar", "confirmar", "confitar", "conformar", "congelar", "congestionar", "conglomerar", "conglutinar", "congratular", "congregar", "congriar", "conhortar", "conjuminar", "conjunyir", "conjurar", "connaturalitzar", "consagrar", "conscienciar", "consentir", "conservar", "consolar", "consolidar", "constipar", "consumir", "contagiar", "contaminar", "contemperar", "contenir", "contorbar", "contornar", "contradir", "contraposar", "contreure", "controlar", "convertir", "conv\u00e8ncer", "corbar", "corcar", "cordar", "coronar", "corporificar", "corregir", "correspondre", "corrompre", "corsecar", "cotitzar", "covar", "crebantar", "cremar", "creure", "criar", "crispar", "cucar", "cuidar", "cuixatrencar", "curar", "curullar", "damnar", "debatre", "decantar", "decidir", "declarar", "decuplicar", "decurvar", "dedicar", "defendre", "defensar", "definir", "deformar", "defugir", "degradar", "deixar", "deixatar", "deixondar", "deixondir", "deixuplinar", "delectar", "delir", "delitar", "denudar", "departir", "depauperar", "depilar", "deportar", "depositar", "depravar", "deprimir", "depurar", "derivar", "desabillar", "desabonar", "desabrigar", "desacalorar", "desacoblar", "desaconductar", "desaconduir", "desacordar", "desacostumar", "desacreditar", "desadherir", "desaferrar", "desafinar", "desagafar", "desagermanar", "desagradar", "desagregar", "desajustar", "desalinear", "desamarrar", "desamigar", "desamistan\u00e7ar", "desamorrar", "desanar", "desanimar", "desaparellar", "desapariar", "desaparroquianar", "desaplicar", "desapropiar", "desar", "desarborar", "desarmar", "desarramadar", "desarrambar", "desarranjar", "desarrapar", "desarreglar", "desarregussar", "desarrelar", "desarrengar", "desarrenglar", "desarrenglerar", "desarrimar", "desarrissar", "desarromangar", "desarrufar", "desarrugar", "desarticular", "desassossegar", "desatansar", "desatapeir", "desatendar", "desavesar", "desave\u00efnar", "desballestar", "desbaratar", "desbarbar", "desbarrar", "desbordar", "desbrancar", "desbraonar", "descabalar", "descabdellar", "descabellar", "descalcificar", "descal\u00e7ar", "descaminar", "descantellar", "descarbonatar", "descarbonitzar", "descarburar", "descargolar", "descarnar", "descarregar", "descarrerar", "descartar", "descastellanitzar", "descatalanitzar", "descelerar", "descentrar", "descenyir", "desclassar", "desclavar", "descloure", "descoagular", "descobrir", "descolgar", "descollar", "descolorar", "descolorir", "descol\u00b7locar", "descompassar", "descompensar", "descompondre", "descomprometre", "descomptar", "desconceptuar", "desconcertar", "desconfortar", "descongelar", "descongestionar", "desconhortar", "desconjuntar", "desconnectar", "descoratjar", "descordar", "descosir", "descotxar", "descrostar", "descular", "desdaurar", "desdelitar", "desdenyar", "desdibuixar", "desdinerar", "desdir", "desdoblar", "desdoblegar", "deseixir", "deselectritzar", "desembabaiar", "desembadalir", "desembadocar", "desemballestar", "desemboirar", "desembolcallar", "desembolcar", "desembolicar", "desembotir", "desembotjar", "desembotornar", "desembo\u00e7ar", "desembravir", "desembrocar", "desembromallar", "desembromar", "desembullar", "desembussar", "desembutllofar", "desemmandrir", "desemmurriar", "desempallar", "desempastar", "desemperesir", "desempernar", "desempipar", "desempobrir", "desempolainar", "desempolsar", "desempolvorar", "desenamorar", "desencadenar", "desencaixar", "desencalimar", "desencalitjar", "desencallar", "desencaminar", "desencantar", "desencaparrar", "desencapotar", "desencaputxar", "desencarar", "desencarcarar", "desencarranquinar", "desencartonar", "desencastar", "desencaterinar", "desencauar", "desencavalcar", "desencavallar", "desencebar", "desencerclar", "desencercolar", "desencimbellar", "desencisar", "desenclavar", "desencoblar", "desencolar", "desencongir", "desencoratjar", "desencorbar", "desencordillar", "desencrespar", "desencrostar", "desendegar", "desendeutar", "desendogalar", "desendolcir", "desendollar", "desendropir", "desenfadar", "desenfadeir", "desenfarfegar", "desenfellonir", "desenferrissar", "desenfetgegar", "desenfilar", "desenfitar", "desenflocar", "desenfocar", "desenfrenar", "desenfuriar", "desenfurismar", "desengandulir", "desenganxar", "desenganyar", "desengatjar", "desengavanyar", "desengomar", "desengormandir", "desengorronir", "desengreixar", "desengrescar", "desengruixir", "desengrutar", "desenguantar", "desenguerxir", "desenllaminir", "desenlla\u00e7ar", "desenlleganyar", "desenllepolir", "desenllorar", "desenlluernar", "desenllustrar", "desennuegar", "desennuvolar", "desenquadernar", "desenquadrar", "desenquimerar", "desenrampar", "desenredar", "desenrederar", "desenrolar", "desenrotllar", "desensabonar", "desensenyorir", "desensonyar", "desensopir", "desensuperbir", "desentaular", "desentelar", "desentendre", "desentenebrar", "desentenebrir", "desenterbolir", "desenterrar", "desentestar", "desentortolligar", "desentrampar", "desentranyar", "desentravessar", "desentrecuixar", "desentrenar", "desentristir", "desentumir", "desentusiasmar", "desenutjar", "desenvelar", "desenvernissar", "desenvescar", "desenvolupar", "desenyorar", "desequilibrar", "desertitzar", "desesmar", "desesperan\u00e7ar", "desesperar", "desespessir", "desestancar", "desestanyar", "desestovar", "desfaixar", "desfai\u00e7onar", "desfanatitzar", "desfardar", "desfasar", "desfermar", "desferrar", "desficiar", "desficiejar", "desfigurar", "desfilar", "desflorir", "desfocar", "desfogar", "desfonar", "desfrarar", "desfrenar", "desfrunzir", "desfullar", "desganar", "desgastar", "desgavellar", "desgla\u00e7ar", "desgraciar", "desgranar", "desgruixar", "desguarnir", "desguerxar", "desguitarrar", "deshabitar", "deshabituar", "deshidratar", "deshumanitzar", "desigualar", "desil\u00b7lusionar", "desimantar", "desincorporar", "desincrustar", "desinfatuar", "desinflamar", "desinflar", "desinhibir", "desintegrar", "desinteressar", "desintoxicar", "desionitzar", "desjunyir", "deslligar", "deslliurar", "desllodrigar", "desllogar", "deslloriguerar", "deslluir", "desllustrar", "desmagnetitzar", "desmaiar", "desmallar", "desmanegar", "desmaquillar", "desmarcar", "desmembrar", "desmillorar", "desmoralitzar", "desmorriar", "desmudar", "desmuntar", "desnacionalitzar", "desnaturar", "desniar", "desnierar", "desnivellar", "desnuar", "desnucar", "desobligar", "desobstruir", "desocupar", "desorbitar", "desordenar", "desorganitzar", "desorientar", "despacientar", "desparar", "desparellar", "despariar", "despassar", "despenjar", "despentinar", "despenyar", "despersonalitzar", "despertar", "despintar", "despistar", "despitar", "despla\u00e7ar", "desplegar", "desplomar", "despoblar", "despolir", "desposseir", "desprendre", "desprestigiar", "desprisar", "despullar", "despuntar", "desrengar", "desroentar", "dessaborir", "dessagnar", "dessecar", "dessolar", "dessoldar", "dessonillar", "dessoterrar", "dessuar", "dessucar", "destacar", "destapar", "destarotar", "destemprar", "destenyir", "desteular", "destintar", "destor\u00e7ar", "destravar", "destrempar", "destrenar", "destriar", "destrossar", "dest\u00f2rcer", "desunglar", "desunir", "desusar", "desvariar", "desvariejar", "desvesar", "desvestir", "desvetllar", "desviar", "desvincular", "desvitrificar", "detenir", "deteriorar", "determinar", "deturar", "devaluar", "dialitzar", "dibuixar", "diferenciar", "difondre", "diftongar", "difuminar", "dignificar", "dilatar", "diluir", "dipositar", "dirigir", "disbauxar", "disciplinar", "disculpar", "disfressar", "disgregar", "disgustar", "dislocar", "disparar", "dispersar", "disposar", "disputar", "disseminar", "dissimilar", "dissipar", "dissociar", "dissoldre", "distanciar", "distendre", "distingir", "distreure", "distribuir", "diversificar", "divertir", "dividir", "divorciar", "divulgar", "doblar", "doblegar", "doctorar", "documentar", "doldre", "domesticar", "domiciliar", "dominar", "donar", "dopar", "dre\u00e7ar", "drogar", "dubtar", "dulcificar", "duplicar", "dutxar", "eclipsar", "efectuar", "efeminar", "eixamar", "eixamenar", "eixamorar", "eixamplar", "eixancar", "eixancarrar", "eixarrancar", "eixarreir", "eixorivir", "eixugar", "electritzar", "electrocutar", "elevar", "elidir", "emancipar", "embabaiar", "embadalir", "embadocar", "embajanir", "embalar", "embalbar", "embalbir", "embancar", "embarbollar", "embarcar", "embardissar", "embarracar", "embarrancar", "embarranquinar", "embarrar", "embarumar", "embarzerar", "embasardir", "embassar", "embastardir", "embellir", "embeure", "embicar", "emblanquir", "emblavir", "embofegar", "embogir", "emboirar", "embolicar", "emborbollar", "emborratxar", "emboscar", "embossar", "embotinar", "embotir", "embo\u00e7ar", "embrancar", "embravir", "embretolir", "embriagar", "embrocar", "embrollar", "embromar", "embrossar", "embrunir", "embrutar", "embrutir", "embullar", "embussar", "embutllofar", "embutxacar", "emmagrir", "emmalaltir", "emmaleir", "emmallar", "emmandrir", "emmarcir", "emmaridar", "emmascarar", "emmatxucar", "emmerdar", "emmerdissar", "emmetzinar", "emmirallar", "emmotllar", "emmudir", "emmusteir", "emmustigar", "emocionar", "empadronar", "empal\u00b7lidir", "empantanar", "empantanegar", "empanxonar", "empapatxar", "emparar", "emparaular", "emparentar", "emparrar", "empastellar", "empastifar", "empastissar", "empatxar", "empedreir", "empeguntar", "empellar", "empeltar", "empenyorar", "emperesir", "emperlar", "empernar", "empetitir", "empilar", "empinar", "empipar", "empitjorar", "empitrar", "empixonar", "emplenar", "emplomallar", "empobrir", "empolainar", "empolistrar", "empolsar", "empolsegar", "empolsimar", "empolsinar", "empolvorar", "empoquir", "emporcar", "emporprar", "empotingar", "emprendre", "emprenyar", "emprovar", "enagrir", "enamorar", "enamoriscar", "enarborar", "enarbrar", "enarcar", "enardir", "enasprar", "enasprir", "encabassar", "encabir", "encaboriar", "encadarnar", "encadenar", "encaixar", "encalbir", "encalimar", "encalitjar", "encallar", "encallir", "encambrar", "encamellar", "encaminar", "encamisar", "encantar", "encaparrar", "encapellar", "encaperonar", "encaperullar", "encaperutxar", "encapirotar", "encapotar", "encapsular", "encapullar", "encaputxar", "encaramel\u00b7lar", "encarar", "encarbonar", "encarir", "encarnar", "encarranquinar", "encarregar", "encarrerar", "encarrilar", "encartonar", "encasquetar", "encastellar", "encauar", "encavallar", "encegar", "encendre", "encepar", "encertir", "encetar", "encimbellar", "enciriar", "enclaustrar", "enclotar", "encloure", "encoblar", "encofurnar", "encoixir", "encomanar", "enconar", "enconcar", "encongir", "encontrar", "encoratjar", "encorbar", "encordar", "encotillar", "encotxar", "encovar", "encrespar", "encreuar", "encrostar", "encrostimar", "encrostissar", "encruelir", "endarreriar", "endarrerir", "endegar", "endentar", "endenyar", "enderrocar", "endeutar", "endinsar", "endogalar", "endolcir", "endolentir", "endossar", "endropir", "endurir", "enemistar", "enervar", "enfadar", "enfadeir", "enfangar", "enfarfegar", "enfarinar", "enfastidir", "enfastijar", "enfellonir", "enfervorir", "enfetgegar", "enfigassar", "enfilar", "enfistular", "enfitar", "enflocar", "enflorar", "enfondir", "enfonsar", "enfonyar", "enforfoguir", "enforinyar", "enfortir", "enfosquir", "enfredar", "enfredolicar", "enfredorar", "enfredorir", "enfrontar", "enfuriar", "enfurir", "enfurismar", "engabiar", "engalavernar", "engallar", "engallardir", "engallir", "engallofir", "engalonar", "engalvanir", "enganar", "engandulir", "enganxar", "enganyar", "engatar", "engatjar", "engelosir", "enginjolar", "enginyar", "engiponar", "englotir", "engolar", "engolir", "engordir", "engorjar", "engormandir", "engorronir", "engrandir", "engreixar", "engrescar", "engrevir", "engroguir", "engronsar", "engronyar", "engrossir", "engruixar", "engruixir", "engrutar", "enguantar", "enguerxir", "enherbar", "enjoiar", "enjoiellar", "enjoncar", "enjullar", "enlairar", "enllacar", "enllaminir", "enllangorir", "enllardar", "enllardissar", "enlla\u00e7ar", "enllefernar", "enllefiscar", "enllepissar", "enllepolir", "enllestir", "enlletgir", "enllistar", "enllorar", "enllordar", "enllotar", "enllustrar", "ennegrir", "ennoblir", "ennovar", "ennuegar", "ennuvolar", "enorgullar", "enquadrar", "enquibir", "enquimerar", "enrabiar", "enramar", "enrampar", "enrancir", "enrarir", "enrasar", "enravenar", "enredar", "enrederar", "enrederir", "enrellentir", "enretirar", "enrevenxinar", "enriallar", "enrigidir", "enrinxolar", "enriquir", "enrobustir", "enrocar", "enrogir", "enrolar", "enronquir", "enrosar", "enrossir", "enrotllar", "enrullar", "enrunar", "ensabonar", "ensagnar", "ensalivar", "ensangonar", "enseguir", "ensenyorir", "ensonyar", "ensopegar", "ensopir", "ensordir", "ensorrar", "ensotar", "ensulsir", "ensuperbir", "entaforar", "entatxonar", "entaular", "entebeir", "entebionar", "entelar", "entendre", "entendrir", "entenebrar", "entenebrir", "enterbolir", "enterrar", "enterrossar", "entestar", "entollar", "entonar", "entornar", "entortellar", "entortolligar", "entrampar", "entrapar", "entravessar", "entrebancar", "entregar", "entregirar", "entrella\u00e7ar", "entrelligar", "entremesclar", "entrenar", "entretenir", "entreveure", "entrevistar", "entristar", "entristir", "entumir", "enturar", "entusiasmar", "enutjar", "envanir", "envellir", "envellutar", "enverdir", "enverinar", "envermellir", "envescar", "enviar", "envigorir", "envilir", "environar", "enviscar", "enviscolar", "envitricollar", "envoltar", "enxarxar", "enxiquir", "enyorar", "equilibrar", "equivaler", "equivocar", "erigir", "eri\u00e7ar", "errar", "esbadiar", "esbadinar", "esbadocar", "esbalair", "esbaldir", "esbaldregar", "esbandir", "esbardellar", "esbargir", "esbarriar", "esbarzerar", "esberlar", "esbocinar", "esboirar", "esboldregar", "esbombar", "esbombolar", "esborifar", "esborrar", "esborrifar", "esborronar", "esbotifarrar", "esbotzar", "esbrancar", "esbraonar", "esbraveir", "esbullar", "escabellar", "escabellonar", "escabotar", "escaldar", "escaldufar", "escalfar", "escalfeir", "escalivar", "escalonar", "escamarlar", "escamnar", "escampar", "escandalitzar", "escantellar", "escantonar", "escanyar", "escapar", "escarmentar", "escarrabillar", "escarxar", "escaure", "escindir", "esclafar", "esclafassar", "esclarir", "esclerosar", "escolar", "escoltar", "escometre", "escondir", "escotar", "escridar", "escridassar", "escrostar", "escrostissar", "escrostonar", "escruixir", "escuar", "escudar", "escuixar", "escular", "escur\u00e7ar", "esc\u00f3rrer", "esdernegar", "esdevenir", "esduir", "esfacelar", "esfereir", "esfilagarsar", "esfondrar", "esfreixurar", "esfullar", "esfumar", "esgallar", "esgardissar", "esgarrar", "esgarrifar", "esgarrinxar", "esgarrinyar", "esgarronar", "esgavellar", "esglaonar", "esgotar", "esgratinyar", "esguardar", "esguerrar", "esllenegar", "esllomar", "esmadeixar", "esmalucar", "esmenar", "esmicar", "esmicolar", "esmolar", "esmorrellar", "esmorronar", "esmortir", "esmunyir", "esmussar", "espalmar", "espantar", "espanyolitzar", "espaordir", "espargir", "esparpallar", "esparpillar", "esparracar", "esparverar", "espassar", "espatllar", "espaventar", "espavilar", "especejar", "especialitzar", "espeda\u00e7ar", "espellifar", "espellir", "espellissar", "espenyar", "esperan\u00e7ar", "esperar", "espesseir", "espessir", "espicassar", "espigar", "espinar", "espitrar", "esplaiar", "esplugar", "espolsar", "espoltrir", "esponjar", "esporuguir", "esposar", "espr\u00e9mer", "espuar", "espuntar", "espunyir", "espu\u00e7ar", "esqueixar", "esquerar", "esquerdar", "esquerdillar", "esquerdissar", "esquin\u00e7ar", "esquitxar", "esquivar", "est", "estabilitzar", "establir", "estacionar", "estalviar", "estamordir", "estancar", "estandarditzar", "estantolar", "estanyar", "estarrufar", "estellar", "estendre", "estepitzar", "estilitzar", "estimbar", "estintolar", "estirar", "estireganyar", "estiuar", "estontolar", "estovar", "estrangeritzar", "estranyar", "estratificar", "estrenar", "estressar", "estretir", "estrinxolar", "estripar", "estroncar", "estropellar", "estr\u00e8nyer", "estubar", "estufar", "esvair", "esvalotar", "esventar", "esvorar", "esvorellar", "eternitzar", "europe\u00eftzar", "evadir", "evaporar", "exacerbar", "exaltar", "examinar", "exasperar", "excedir", "excitar", "exclamar", "excloure", "exculpar", "excusar", "exercitar", "exfoliar", "exhalar", "exhaurir", "exhibir", "exiliar", "eximir", "exornar", "expandir", "expatriar", "explicar", "exposar", "expressar", "extasiar", "extenuar", "exterioritzar", "extingir", "extraviar", "extremar", "faixar", "familiaritzar", "fanatitzar", "fastiguejar", "fatigar", "federar", "felicitar", "feminitzar", "ferir", "fiar", "ficar", "figurar", "filtrar", "fingir", "firar", "fixar", "flagel\u00b7lar", "florir", "folrar", "foraviar", "forcar", "forjar", "formalitzar", "formar", "fortificar", "fossilitzar", "fotre", "fraccionar", "fracturar", "fragmentar", "francesitzar", "franquejar", "fregar", "fregir", "frisar", "fumar", "fundar", "gabar", "gastar", "gaudir", "gelar", "generalitzar", "gestar", "ginyar", "girar", "gitar", "gla\u00e7ar", "gloriejar", "governar", "graduar", "gramaticalitzar", "gratar", "gratular", "gravar", "grecitzar", "grillar", "gronxar", "gronxejar", "gronxolar", "guanyar", "guardar", "guarir", "guarnir", "guerxar", "guiar", "guillar", "habituar", "hebra\u00eftzar", "hel\u00b7lenitzar", "hemodialitzar", "herniar", "hibridar", "hidratar", "hissar", "honorar", "honrar", "horripilar", "horroritzar", "hostatjar", "humanitzar", "humiliar", "humitejar", "identificar", "igualar", "il\u00b7luminar", "il\u00b7lusionar", "il\u00b7lustrar", "imaginar", "immergir", "immolar", "impacientar", "implicar", "imposar", "impressionar", "imprimir", "impurificar", "incarcerar", "incendiar", "inclinar", "incomodar", "incorporar", "incrementar", "incrustar", "independitzar", "indignar", "indisposar", "inebriar", "infatuar", "infectar", "infestar", "infiltrar", "inflamar", "inflar", "informar", "ingerir", "inhabilitar", "inhibir", "iniciar", "inquietar", "inscriure", "insinuar", "inspirar", "instal\u00b7lar", "instruir", "insubordinar", "insultar", "insurreccionar", "integrar", "intensificar", "interessar", "interferir", "internar", "interposar", "interrompre", "intranquil\u00b7litzar", "introduir", "inundar", "invaginar", "inventar", "ionitzar", "irritar", "islamitzar", "isolar", "jubilar", "jugar", "junyir", "justificar", "lamentar", "laxar", "lignificar", "limitar", "llampar", "llan\u00e7ar", "llassar", "llatinitzar", "llepar", "lletrejar", "llevar", "llicenciar", "lligar", "lliurar", "llogar", "lluir", "localitzar", "lucrar", "macerar", "malacostumar", "malavesar", "maliciar", "mallar", "malpensar", "mamar", "mancomunar", "manegar", "manejar", "manifestar", "mantenir", "maquillar", "marcir", "marejar", "marginar", "maridar", "marinejar", "mascarar", "massificar", "masturbar", "matar", "materialitzar", "matricular", "matxucar", "mecanitzar", "mediumitzar", "menar", "menjar", "mentalitzar", "menysprear", "meravellar", "mer\u00e8ixer", "mesclar", "metal\u00b7litzar", "metamorfosar", "meteoritzar", "migrar", "millorar", "mineralitzar", "mirar", "mobilitzar", "mocar", "moderar", "modernitzar", "modificar", "molestar", "morfondre", "morir", "morrejar", "mortificar", "mossegar", "mostrar", "moure", "mudar", "mullar", "multiplicar", "musteir", "mustiar", "mustigar", "mutilar", "nacionalitzar", "naturalitzar", "necrosar", "negar", "neguitejar", "netejar", "nonuplicar", "normalitzar", "nuar", "oblidar", "obligar", "obnubilar", "obscurir", "occidentalitzar", "occitanitzar", "ocultar", "ocupar", "ofegar", "oferir", "ofuscar", "ombrar", "omplir", "operar", "oposar", "ordenar", "orejar", "organitzar", "orgullar", "orientalitzar", "orientar", "originar", "orinar", "oscar", "oxigenar", "pacificar", "paganitzar", "pagar", "pansir", "parapetar", "parar", "parlar", "particularitzar", "partir", "passar", "passejar", "pedregar", "pedrejar", "pellar", "penjar", "pensar", "pentinar", "perca\u00e7ar", "perfeccionar", "perfilar", "permetre", "persignar", "persuadir", "pessigar", "petar", "picar", "pintar", "pirar", "plantar", "plantificar", "podrir", "polaritzar", "polir", "pol\u00b7linitzar", "pondre", "popularitzar", "portar", "posar", "possessionar", "posticar", "postrar", "prear", "precipitar", "prendre", "preocupar", "preparar", "presentar", "prestar", "prevaler", "privar", "proclamar", "prodigar", "produir", "professionalitzar", "proletaritzar", "prometre", "pronunciar", "propagar", "propalar", "proposar", "prostituir", "prostrar", "prou", "proveir", "pujar", "punxar", "purificar", "putejar", "quadrar", "qualificar", "quallar", "quedar", "quitar", "rabejar", "radicalitzar", "rarificar", "ratificar", "reafirmar", "realitzar", "rebaixar", "rebentar", "reblir", "rebolcar", "rebullir", "recargolar", "reciclar", "reciprocar", "recloure", "recobrar", "recollir", "recolzar", "reconcentrar", "reconciliar", "reconstituir", "recordar", "recrear", "recriminar", "rectificar", "reencarnar", "reenganxar", "refer", "referir", "refermar", "reflectir", "refocil\u00b7lar", "refor\u00e7ar", "refractar", "refredar", "refrenar", "refrescar", "refringir", "refugiar", "refusar", "regalar", "regelar", "regirar", "rehabilitar", "rehidratar", "reincorporar", "reinflar", "reinstal\u00b7lar", "reintegrar", "rejovenir", "relacionar", "relaxar", "rellentir", "relligar", "rellogar", "remenar", "remetre", "remirar", "remollir", "remudar", "remuntar", "rendir", "renovar", "renovellar", "rentar", "repatriar", "repenjar", "repensar", "repetir", "repintar", "replegar", "replujar", "repodrir", "reportar", "reposar", "representar", "reprimir", "reproduir", "repuntar", "rescabalar", "reservar", "resguardar", "resignar", "resinificar", "resistir", "resoldre", "responsabilitzar", "resquitar", "ressecar", "ressobinar", "restablir", "retardar", "retenir", "retintar", "retirar", "retractar", "retre", "retreure", "retrobar", "reunir", "reveixinar", "revelar", "revellir", "revenxinar", "revestir", "revifar", "reviscolar", "revoltar", "rifar", "rinxolar", "riure", "romanitzar", "rombollar", "rompre", "rostir", "rovellar", "ruboritzar", "russificar", "sacrificar", "salmorrar", "salsir", "salvar", "santificar", "satel\u00b7litzar", "secularitzar", "sedimentar", "segar", "segregar", "seguir", "sentir", "senyar", "separar", "significar", "silicificar", "sincerar", "sindicar", "singularitzar", "sinitzar", "situar", "sobrealimentar", "sobreexcitar", "sobreposar", "sobresaltar", "sobresanar", "sobresaturar", "sobtar", "socarrar", "solapar", "solar", "sola\u00e7ar", "soldar", "solidaritzar", "solidificar", "sollar", "sollevar", "solvatar", "somorgollar", "soplujar", "sostreure", "sotaplujar", "sotmetre", "suberificar", "suberitzar", "subestimar", "submergir", "subscriure", "suggestionar", "sulfatar", "sulfurar", "sumar", "sumir", "superar", "tallar", "tancar", "tant", "tapar", "temperar", "tenyir", "terraplenar", "tirar", "titular", "tocar", "tombar", "torbar", "torejar", "tornar", "torrar", "trabucar", "tractar", "tranquil\u00b7litzar", "transfigurar", "transformar", "translimitar", "transmetre", "transmutar", "transparentar", "transvasar", "trasmudar", "trasplantar", "trastocar", "trastornar", "triar", "tribular", "trifurcar", "trobar", "t\u00f2rcer", "ulcerar", "ullar", "unir", "universalitzar", "untar", "vaporitzar", "velar", "venjar", "ventar", "vessar", "vestir", "viciar", "vinclar", "vincular", "vitrificar", "volar", "volatilitzar", "xalar", "xutar");
    private static final List<String> excepVerbsPotencialmentPronominals = Arrays.asList("voler");
    private static final List<String> verbHaver = Arrays.asList("haver");
    private static final Pattern NO_VERB = Pattern.compile("N.*|A.*|_GN_.*");
    private static final Pattern VERB = Pattern.compile("V.*");
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V.[SI].*");
    private static final Pattern VERB_INDSUBJIMP = Pattern.compile("V.[MSI].*");
    private static final Pattern VERB_IMP = Pattern.compile("V.M.*");
    private static final Pattern VERB_INF = Pattern.compile("V.N.*");
    private static final Pattern VERB_INFGER = Pattern.compile("V.[NG].*");
    private static final Pattern VERB_GERUNDI = Pattern.compile("V.G.*");
    private static final Pattern VERB_PARTICIPI = Pattern.compile("V.P.*");
    private static final Pattern VERB_AUXILIAR = Pattern.compile("VA.*");
    private static final Pattern PREP_VERB_PRONOM = Pattern.compile("RN|SPS00|V.*|P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
    private static final Pattern PREP_VERB_PRONOM_ADV = Pattern.compile("RG.*|.*LOC_ADV.*|SPS00|V.*|P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
    private static final List<String> cometes = Arrays.asList("\"", "'", "\u2018", "\u2019", "\u201c", "\u201d", "\u00ab", "\u00bb");
    private static final Pattern VERB_PRONOM = Pattern.compile("V.*|P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
    private static final Pattern VERB_1S = Pattern.compile("V...1S..?");
    private static final Pattern VERB_2S = Pattern.compile("V...2S..?");
    private static final Pattern VERB_3S = Pattern.compile("V...3S..?");
    private static final Pattern VERB_1P = Pattern.compile("V...1P..?");
    private static final Pattern VERB_2P = Pattern.compile("V...2P..?");
    private static final Pattern VERB_3P = Pattern.compile("V...3P..?");
    private static final Pattern PRONOM_FEBLE_1S = Pattern.compile("P010S000");
    private static final Pattern PRONOM_FEBLE_2S = Pattern.compile("P020S000");
    private static final Pattern PRONOM_FEBLE_3S = Pattern.compile("P0300000");
    private static final Pattern PRONOM_FEBLE_1P = Pattern.compile("P010P000");
    private static final Pattern PRONOM_FEBLE_2P = Pattern.compile("P020P000");
    private static final Pattern PRONOM_FEBLE_3P = Pattern.compile("P0300000");
    private static final Pattern PRONOM_FEBLE_13S = Pattern.compile("P010S000|P0300000");
    private static final Pattern PRONOM_FEBLE_23S = Pattern.compile("P020S000|P0300000");
    private static final Pattern PRONOM_FEBLE_3S_TOTS = Pattern.compile("P.3.[^PN].*");
    private static final Pattern PRONOM_FEBLE = Pattern.compile("P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
    private static final Pattern PRONOM_REFLEXIU = Pattern.compile("P0.0.*");
    private static final Pattern LEMMA_EN = Pattern.compile("en");
    private static final Pattern POSTAG_EN = Pattern.compile("PP3CN000");
    private static final Pattern LEMMA_HI = Pattern.compile("hi");
    private static final Pattern POSTAG_HI = Pattern.compile("PP3CN000");
    private static final Pattern LEMMA_ES = Pattern.compile("es");
    private static final Pattern POSTAG_ES = Pattern.compile("P0300000");
    private static final Pattern LEMMA_PRONOM_CI = Pattern.compile("jo|tu|ell");
    private static final Pattern POSTAG_PRONOM_CI = Pattern.compile("P0.*|PP3CP000|PP3CSD00");
    private static final Pattern LEMMA_PRONOM_CD = Pattern.compile("jo|tu|ell");
    private static final Pattern POSTAG_PRONOM_CD = Pattern.compile("P0.*|PP3CP000|PP3..A00");
    private static final Pattern POSTAG_CD = Pattern.compile("_GN_.*|N.*|DI.*|P[DI].*");
    private static final Pattern LEMMA_DE = Pattern.compile("de");
    private static final Pattern POSTAG_DE = Pattern.compile("SPS00");
    private static final Pattern POSTAG_PREPOSICIO = Pattern.compile("SPS00");
    private static final Pattern LEMMA_PREP_A_PER = Pattern.compile("a|per");
    private static final Pattern POSTAG_ADVERBI = Pattern.compile("RG.*|.*LOC_ADV.*");
    private static final Pattern ANYMESDIA = Pattern.compile("any|mes|dia");
    private static final Pattern REFLEXIU_POSPOSAT = Pattern.compile("-[mts]|-[mts]e|'[mts]|-nos|'ns|-vos|-us", 66);
    private static final Pattern REFLEXIU_ANTEPOSAT = Pattern.compile("e[mts]|[mts]e|ens|us|vos|'[mts]|[mts]'|'ns", 66);
    private static final Pattern PRONOMFEBLE_POSPOSAT = Pattern.compile("['-].+");
    private static final Pattern SUBJECTE_PERSONAL_POSTAG = Pattern.compile("NC.*|NP.*|_GN_.*|PI.*");
    private static final Pattern SUBJECTE_PERSONAL_NO_POSTAG = Pattern.compile("complement.*|D.*|A.*|PX.*");
    private static final Pattern SUBJECTE_PERSONAL_TOKEN = Pattern.compile("alg\u00fa|algun|jo|mi|tu|ella?|nosaltres|vosaltres|elle?s|vost[\u00e8\u00e9]s?|v\u00f3s", 66);
    private static final Pattern SUBJECTE_PERSONAL_NO_LEMMA = Pattern.compile("dia|any|mes|segle|dilluns|dimarts|dimecres|dijous|divendres|dissabte|diumenge|gener|febrer|mar\u00e7|abril|maig|juny|juliol|agost|setembre|octubre|novembre|desembre");
    private static final Pattern SUBJECTE_PERSONAL_SING_POSTAG = Pattern.compile("N..[SN].*|_GN_.S|PI..[SN].*|_possible_nompropi|UNKNOWN");
    private static final Pattern SUBJECTE_PERSONAL_SING_TOKEN = Pattern.compile("alg\u00fa|algun|jo|mi|tu|ella?|vost[\u00e8\u00e9]|v\u00f3s", 66);
    private static final Pattern SUBJECTE_PERSONAL_PL_POSTAG = Pattern.compile("N..[PN].*|_GN_.P|PI..[PN].*|_possible_nompropi|UNKNOWN");
    private static final Pattern SUBJECTE_PERSONAL_PL_TOKEN = Pattern.compile("alguns|nosaltres|vosaltres|elle?s|vost[\u00e8\u00e9]s", 66);
    private static final Pattern SUBJECTE_3S_POSTAG = Pattern.compile("N..[SN].*|_GN_.S|PI..[SN].*");
    private static final Pattern SUBJECTE_3S_TOKEN = Pattern.compile("alg\u00fa|algun|ella?|vost[\u00e8\u00e9]|v\u00f3s", 66);
    private static final Pattern SUBJECTE_3S_NO_POSTAG = Pattern.compile("complement.*");
    private static final Pattern SUBJECTE_3S_NO_TOKEN = Pattern.compile("jo|tu|mi|nosaltres|vosaltres|elle?s", 66);
    private static final Pattern TRENCA_COMPTE = Pattern.compile("PR.*|CS|CC|_PUNCT.*|.*LOC_CONJ.*");
    private static final Pattern TRENCA_COMPTE2 = Pattern.compile("SENT_START|CC|_PUNCT.*|.*LOC_CONJ.*");
    private static final List<String> partsCos = Arrays.asList("pit", "galta", "cap", "cor", "cara", "ull", "front", "m\u00e0", "peu", "bra\u00e7", "colze", "genoll", "cabell");
    private static final List<String> pronomJo = Arrays.asList("jo");

    public ReflexiveVerbsRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category("Verbs"));
        }
        this.setLocQualityIssueType(ITSIssueType.Grammar);
    }

    public String getId() {
        return "REFLEXIVE_VERBS";
    }

    public String getDescription() {
        return "Verbs reflexius: comproveu que porten el pronom adequat.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            String msg;
            if (i > 1 && StringTools.startsWithUppercase((String)tokens[i].getToken()) || !this.matchPostagRegexp(tokens[i], VERB) || this.matchPostagRegexp(tokens[i], NO_VERB)) continue;
            String token = tokens[i].getToken().toLowerCase();
            if (i + 2 < tokens.length && tokens[i].hasLemma("donar") && (tokens[i + 1].getToken().equals("compte") || tokens[i + 2].getToken().equals("compte"))) {
                if (!this.isThereReflexivePronoun(tokens, i) || this.isPhraseImpersonalVerbS(tokens, i)) continue;
                msg = "Expressi\u00f3 incorrecta si equival a 'adonar-se', correcta si vol dir 'retre compte'.";
                ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "Expressi\u00f3 incorrecta si equival a 'adonar-se', correcta si vol dir 'retre compte'.", "Possible error");
                ruleMatches.add(ruleMatch);
            }
            if (!(i + 2 >= tokens.length || !this.matchLemmaList(tokens[i], verbsPortarDur) || this.matchPostagRegexp(tokens[i], VERB_INF) && this.isThereBefore(tokens, i, LEMMA_PREP_A_PER, POSTAG_PREPOSICIO) || this.hasVerbMultipleReadings(tokens[i]) || !this.isThereReflexivePronoun(tokens, i) || !this.isThereAfterWithoutPreposition(tokens, i, POSTAG_CD) || this.isThereVerbBeforeList(tokens, i, verbsDeixarFer) || this.isThereVerbBeforeList(tokens, i, verbsPotencialmentPronominals) && !this.isThereVerbBeforeList(tokens, i, excepVerbsPotencialmentPronominals) || this.matchPostagRegexp(tokens[i + 1], POSTAG_ADVERBI) || this.matchPostagRegexp(tokens[i + 2], POSTAG_ADVERBI) || this.matchLemmaRegexp(tokens[i + 2], ANYMESDIA) || this.isPhraseImpersonalVerbSP(tokens, i))) {
                if (this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereSubject3SBefore(tokens, i, TRENCA_COMPTE)) continue;
                String suggestion = tokens[i].hasLemma("portar") ? "em" + token : (token.equalsIgnoreCase("du") ? "end\u00fa" : "en" + token);
                String msg2 = "\u00bfVol\u00edeu dir <suggestion>" + suggestion + "</suggestion>?";
                RuleMatch ruleMatch2 = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), msg2, "Possible error");
                ruleMatches.add(ruleMatch2);
                continue;
            }
            if (i + 1 < tokens.length && this.matchPostagRegexp(tokens[i], VERB_INF) && !this.matchPostagRegexp(tokens[i - 1], POSTAG_PREPOSICIO) && this.isThereVerbBeforeListLimit(tokens, i, verbsDeixarFer, 3) && this.isThereRedundantPronoun(tokens, i) && this.isThereBefore(tokens, i, LEMMA_PRONOM_CD, POSTAG_PRONOM_CD) && this.matchRegexp(tokens[i + 1].getToken(), REFLEXIU_POSPOSAT)) {
                msg = "En aquesta per\u00edfrasi verbal el pronom reflexiu posterior \u00e9s redundant.";
                ruleMatch = new RuleMatch((Rule)this, tokens[i + 1].getStartPos(), tokens[i + 1].getStartPos() + tokens[i + 1].getToken().length(), "En aquesta per\u00edfrasi verbal el pronom reflexiu posterior \u00e9s redundant.", "Pronom redundant");
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (this.matchLemmaRegexp(tokens[i], VERB_AUTO) || this.matchLemmaList(tokens[i], verbsPronominals)) {
                if (this.matchLemmaList(tokens[i], excepVerbsPronominals) || this.matchPostagRegexp(tokens[i], VERB_PARTICIPI) && !tokens[i - 1].hasLemma("haver") || this.isThereVerbBeforeList(tokens, i, verbsDeixarFer) && (this.isThereBefore(tokens, i, LEMMA_PRONOM_CD, POSTAG_PRONOM_CD) || this.isThereBefore(tokens, i, LEMMA_PRONOM_CI, POSTAG_PRONOM_CI) || this.isThereAfterWithoutPreposition(tokens, i, POSTAG_CD)) || this.isThereReflexivePronoun(tokens, i)) continue;
                msg = "Aquest verb \u00e9s pronominal. Probablement falta un pronom.";
                ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "Aquest verb \u00e9s pronominal. Probablement falta un pronom.", "Verb pronominal: falta un pronom");
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (this.matchLemmaList(tokens[i], verbsNoPronominals)) {
                if (this.matchLemmaList(tokens[i], excepVerbsNoPronominals) || !this.isThereReflexivePronoun(tokens, i) || this.matchLemmaList(tokens[i], verbsNoPronominalsImpersonals2) && this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereBefore(tokens, i, LEMMA_DE, POSTAG_DE) && this.isThereVerbBeforeList(tokens, i, verbHaver) || this.isThereVerbBeforeList(tokens, i, verbsSovintAmbComplement) || this.isThereVerbBeforeList(tokens, i, verbsPotencialmentPronominals) && !this.isThereVerbBeforeList(tokens, i, excepVerbsPotencialmentPronominals) || this.isThereVerbBefore(tokens, i, VERB_AUTO) || this.isThereVerbBeforeList(tokens, i, verbsPronominals) || this.matchLemmaList(tokens[i], verbsNoPronominalsImpersonals) && this.isPhraseImpersonalVerbS(tokens, i) || this.matchLemmaList(tokens[i], verbsNoPronominalsImpersonals2) && this.isPhraseImpersonalVerbSP(tokens, i) || tokens[i].hasLemma("olorar") && this.isThereNearLemma(tokens, i, partsCos)) continue;
                msg = "Aquest verb no \u00e9s pronominal. Probablement sobra un pronom.";
                ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "Aquest verb no \u00e9s pronominal. Probablement sobra un pronom.", "Verb no pronominal");
                ruleMatches.add(ruleMatch);
            }
            if (!this.matchLemmaList(tokens[i], verbsMoviment) || this.matchPostagRegexp(tokens[i], VERB_AUXILIAR) || this.matchLemmaList(tokens[i], excepVerbsMoviment) || this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereBefore(tokens, i, LEMMA_DE, POSTAG_DE) && this.isThereVerbBeforeList(tokens, i, verbHaver) || this.isThereVerbBeforeList(tokens, i, verbsSovintAmbComplement) || this.isThereVerbBeforeList(tokens, i, verbsPotencialmentPronominals) && !this.isThereVerbBeforeList(tokens, i, excepVerbsPotencialmentPronominals) || this.isThereVerbBefore(tokens, i, VERB_AUTO) || this.isThereVerbBeforeList(tokens, i, verbsPronominals) || this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereNearLemma(tokens, i, partsCos) || (tokens[i].hasLemma("venir") || tokens[i].hasLemma("anar")) && i + 1 < tokens.length && this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.matchPostagRegexp(tokens[i + 1], POSTAG_ADVERBI) && !this.isThereNearWord(tokens, i, pronomJo) || tokens[i].hasLemma("venir") && (i + 2 < tokens.length && tokens[i + 1].getToken().equals("de") && tokens[i + 2].getToken().equals("gust") || this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereAfterWithoutPreposition(tokens, i, POSTAG_CD) && !this.isThereNearWord(tokens, i, pronomJo) || this.isThereAfter(tokens, i, VERB_INF)) || (!tokens[i].hasLemma("anar") ? this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && !this.isThereBefore(tokens, i, LEMMA_PRONOM_CI, POSTAG_PRONOM_CI) && !this.isTherePersonalSubjectBefore(tokens, i, TRENCA_COMPTE) : this.isThereAfter(tokens, i, VERB_GERUNDI) || this.isThereVerbAfterList(tokens, i, verbsPotencialmentPronominals) || this.isThereVerbAfter(tokens, i, VERB_AUTO) || this.isThereVerbAfterList(tokens, i, verbsPronominals) || this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && this.isThereSubject3SBefore(tokens, i, TRENCA_COMPTE) || this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && !this.isThereBefore(tokens, i, LEMMA_PRONOM_CI, POSTAG_PRONOM_CI) && (!this.isTherePersonalSubjectBefore(tokens, i, TRENCA_COMPTE) || this.isThereBefore(tokens, i, LEMMA_HI, POSTAG_HI)) && this.isVerbNumberPerson(tokens, i, VERB_3S))) continue;
            if (!this.isThereReflexivePronoun(tokens, i) || this.isTherePronoun(tokens, i, LEMMA_EN, POSTAG_EN)) continue;
            msg = "No useu com a pronominal aquest verb, o b\u00e9 afegiu-hi el pronom 'en'.";
            ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "No useu com a pronominal aquest verb, o b\u00e9 afegiu-hi el pronom 'en'.", "Falta el pronom 'en'");
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private Pattern pronomPattern(AnalyzedTokenReadings aToken) {
        if (this.matchPostagRegexp(aToken, VERB_1S) && this.matchPostagRegexp(aToken, VERB_3S)) {
            return PRONOM_FEBLE_13S;
        }
        if (this.matchPostagRegexp(aToken, VERB_2S) && this.matchPostagRegexp(aToken, VERB_3S)) {
            return PRONOM_FEBLE_23S;
        }
        if (this.matchPostagRegexp(aToken, VERB_1S)) {
            return PRONOM_FEBLE_1S;
        }
        if (this.matchPostagRegexp(aToken, VERB_2S)) {
            return PRONOM_FEBLE_2S;
        }
        if (this.matchPostagRegexp(aToken, VERB_3S)) {
            return PRONOM_FEBLE_3S;
        }
        if (this.matchPostagRegexp(aToken, VERB_1P)) {
            return PRONOM_FEBLE_1P;
        }
        if (this.matchPostagRegexp(aToken, VERB_2P)) {
            return PRONOM_FEBLE_2P;
        }
        if (this.matchPostagRegexp(aToken, VERB_3P)) {
            return PRONOM_FEBLE_3P;
        }
        return null;
    }

    private boolean hasVerbMultipleReadings(AnalyzedTokenReadings aToken) {
        return this.matchPostagRegexp(aToken, VERB_1S) && this.matchPostagRegexp(aToken, VERB_3S) || this.matchPostagRegexp(aToken, VERB_2S) && this.matchPostagRegexp(aToken, VERB_3S);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private boolean matchLemmaRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getLemma();
            if (posTag == null || !(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private boolean matchLemmaList(AnalyzedTokenReadings aToken, List<String> list) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            if (!list.contains(analyzedToken.getLemma())) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private boolean matchRegexp(String s, Pattern pattern) {
        Matcher m = pattern.matcher(s);
        return m.matches();
    }

    private boolean isThereReflexivePronoun(AnalyzedTokenReadings[] tokens, int i) {
        block27: {
            boolean keepCounting;
            block28: {
                int j;
                Pattern pPronomBuscat = null;
                if (this.matchPostagRegexp(tokens[i], VERB_INDSUBJ) && (pPronomBuscat = this.pronomPattern(tokens[i])) != null) {
                    keepCounting = true;
                    for (j = 1; i - j > 0 && j < 4 && keepCounting; ++j) {
                        if (this.matchPostagRegexp(tokens[i - j], pPronomBuscat) && this.matchRegexp(tokens[i - j].getToken(), REFLEXIU_ANTEPOSAT)) {
                            return true;
                        }
                        keepCounting = this.matchPostagRegexp(tokens[i - j], PRONOM_FEBLE);
                    }
                }
                if (this.matchPostagRegexp(tokens[i], VERB_IMP) && (pPronomBuscat = this.pronomPattern(tokens[i])) != null && i + 1 < tokens.length && this.matchPostagRegexp(tokens[i + 1], pPronomBuscat) && this.matchRegexp(tokens[i + 1].getToken(), REFLEXIU_POSPOSAT)) {
                    return true;
                }
                if (this.matchPostagRegexp(tokens[i], VERB_PARTICIPI) && tokens[i - 1].hasLemma("haver")) {
                    if (this.matchPostagRegexp(tokens[i - 1], VERB_INDSUBJ)) {
                        pPronomBuscat = this.pronomPattern(tokens[i - 1]);
                        if (pPronomBuscat != null) {
                            keepCounting = true;
                            for (j = 2; i - j > 0 && j < 5 && keepCounting; ++j) {
                                if (this.matchPostagRegexp(tokens[i - j], pPronomBuscat) && this.matchRegexp(tokens[i - j].getToken(), REFLEXIU_ANTEPOSAT)) {
                                    return true;
                                }
                                keepCounting = this.matchPostagRegexp(tokens[i - j], PRONOM_FEBLE);
                            }
                        }
                    } else if (this.matchPostagRegexp(tokens[i - 1], VERB_INF) && this.matchPostagRegexp(tokens[i - 2], VERB_INDSUBJ) && (pPronomBuscat = this.pronomPattern(tokens[i - 2])) != null) {
                        keepCounting = true;
                        for (j = 3; i - j > 0 && j < 5 && keepCounting; ++j) {
                            if (this.matchPostagRegexp(tokens[i - j], pPronomBuscat) && this.matchRegexp(tokens[i - j].getToken(), REFLEXIU_ANTEPOSAT)) {
                                return true;
                            }
                            keepCounting = this.matchPostagRegexp(tokens[i - j], PRONOM_FEBLE);
                        }
                    }
                }
                if (!this.matchPostagRegexp(tokens[i], VERB_INFGER)) break block27;
                int k = 1;
                keepCounting = true;
                boolean foundVerb = false;
                while (i - k > 0 && keepCounting && !foundVerb) {
                    foundVerb = this.matchPostagRegexp(tokens[i - k], VERB_INDSUBJIMP);
                    keepCounting = this.matchPostagRegexp(tokens[i - k], PREP_VERB_PRONOM);
                    if (this.matchPostagRegexp(tokens[i - k], VERB_INDSUBJ) && this.matchPostagRegexp(tokens[i - k + 1], VERB_INFGER)) {
                        keepCounting = false;
                    }
                    if (this.matchPostagRegexp(tokens[i - k], VERB_INFGER) && this.matchPostagRegexp(tokens[i - k + 1], PRONOM_FEBLE) && !this.matchRegexp(tokens[i - k + 1].getToken(), PRONOMFEBLE_POSPOSAT)) {
                        keepCounting = false;
                    }
                    ++k;
                }
                if (!foundVerb) break block28;
                if ((pPronomBuscat = this.pronomPattern(tokens[i - --k])) == null) break block27;
                if (i + 1 < tokens.length && this.matchPostagRegexp(tokens[i + 1], pPronomBuscat) && this.matchRegexp(tokens[i + 1].getToken(), REFLEXIU_POSPOSAT)) {
                    return true;
                }
                int j2 = 1;
                keepCounting = true;
                while (i - j2 > 0 && keepCounting) {
                    if (j2 == 1 && this.matchPostagRegexp(tokens[i - j2], pPronomBuscat)) {
                        return true;
                    }
                    if (j2 > 1 && this.matchPostagRegexp(tokens[i - j2], pPronomBuscat) && (!this.matchRegexp(tokens[i - j2].getToken(), REFLEXIU_POSPOSAT) || j2 <= k)) {
                        return true;
                    }
                    boolean bl = keepCounting = this.matchPostagRegexp(tokens[i - j2], PREP_VERB_PRONOM) && (j2 <= k - 1 || !this.matchPostagRegexp(tokens[i - j2], VERB_PARTICIPI)) && !this.matchPostagRegexp(tokens[i - j2], TRENCA_COMPTE2);
                    if (tokens[i - j2].getToken().equalsIgnoreCase("per") && tokens[i - j2 + 1].getToken().equalsIgnoreCase("a")) {
                        keepCounting = false;
                    }
                    if (this.matchPostagRegexp(tokens[i - j2], VERB_INFGER) && this.matchPostagRegexp(tokens[i - j2 + 1], PRONOM_FEBLE) && !this.matchRegexp(tokens[i - j2 + 1].getToken(), PRONOMFEBLE_POSPOSAT)) {
                        keepCounting = false;
                    }
                    ++j2;
                }
                break block27;
            }
            if (i + 1 < tokens.length && this.matchPostagRegexp(tokens[i + 1], PRONOM_REFLEXIU) && this.matchRegexp(tokens[i + 1].getToken(), REFLEXIU_POSPOSAT)) {
                return true;
            }
            int j = 1;
            keepCounting = true;
            while (i - j > 0 && keepCounting) {
                if (this.matchPostagRegexp(tokens[i - j], PRONOM_REFLEXIU)) {
                    return true;
                }
                keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
                if (tokens[i - j].getToken().equalsIgnoreCase("per") && tokens[i - j + 1].getToken().equalsIgnoreCase("a")) {
                    keepCounting = false;
                }
                if (this.matchPostagRegexp(tokens[i - j], VERB_INFGER) && this.matchPostagRegexp(tokens[i - j + 1], PRONOM_FEBLE) && !this.matchRegexp(tokens[i - j + 1].getToken(), PRONOMFEBLE_POSPOSAT)) {
                    keepCounting = false;
                }
                ++j;
            }
        }
        return false;
    }

    private boolean isTherePronoun(AnalyzedTokenReadings[] tokens, int i, Pattern lemma, Pattern postag) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchPostagRegexp(tokens[i - j], postag) && this.matchLemmaRegexp(tokens[i - j], lemma)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            ++j;
        }
        j = 1;
        keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchPostagRegexp(tokens[i + j], postag) && this.matchLemmaRegexp(tokens[i + j], lemma)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i + j], PREP_VERB_PRONOM);
            ++j;
        }
        return false;
    }

    private boolean isThereBefore(AnalyzedTokenReadings[] tokens, int i, Pattern lemma, Pattern postag) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchPostagRegexp(tokens[i - j], postag) && this.matchLemmaRegexp(tokens[i - j], lemma)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            ++j;
        }
        return false;
    }

    private boolean isThereBeforePostag(AnalyzedTokenReadings[] tokens, int i, Pattern postag) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchPostagRegexp(tokens[i - j], postag)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            ++j;
        }
        return false;
    }

    private boolean isThereAfter(AnalyzedTokenReadings[] tokens, int i, Pattern postag) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchPostagRegexp(tokens[i + j], postag)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i + j], PREP_VERB_PRONOM_ADV) || cometes.contains(tokens[i + j].getToken());
            ++j;
        }
        return false;
    }

    private boolean isThereAfterWithoutPreposition(AnalyzedTokenReadings[] tokens, int i, Pattern postag) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchPostagRegexp(tokens[i + j], postag)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i + j], VERB_PRONOM) || cometes.contains(tokens[i + j].getToken());
            ++j;
        }
        return false;
    }

    private boolean isThereVerbBefore(AnalyzedTokenReadings[] tokens, int i, Pattern lemma) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchLemmaRegexp(tokens[i - j], lemma)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            if (tokens[i - j].getToken().equalsIgnoreCase("per") && tokens[i - j + 1].getToken().equalsIgnoreCase("a")) {
                keepCounting = false;
            }
            if (this.matchPostagRegexp(tokens[i - j], VERB_INDSUBJ) && this.matchPostagRegexp(tokens[i - j + 1], VERB_INFGER)) {
                keepCounting = false;
            }
            ++j;
        }
        return false;
    }

    private boolean isThereVerbAfter(AnalyzedTokenReadings[] tokens, int i, Pattern lemma) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchLemmaRegexp(tokens[i + j], lemma)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i + j], PREP_VERB_PRONOM);
            ++j;
        }
        return false;
    }

    private boolean isThereVerbBeforeList(AnalyzedTokenReadings[] tokens, int i, List<String> lemmas) {
        return this.isThereVerbBeforeListLimit(tokens, i, lemmas, 10);
    }

    private boolean isThereVerbBeforeListLimit(AnalyzedTokenReadings[] tokens, int i, List<String> lemmas, int limit) {
        boolean keepCounting = true;
        for (int j = 1; i - j > 0 && keepCounting && j < limit; ++j) {
            if (this.matchLemmaList(tokens[i - j], lemmas)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            if (tokens[i - j].getToken().equalsIgnoreCase("per") && tokens[i - j + 1].getToken().equalsIgnoreCase("a")) {
                keepCounting = false;
            }
            if (!this.matchPostagRegexp(tokens[i - j], VERB_INDSUBJ) || !this.matchPostagRegexp(tokens[i - j + 1], VERB_INFGER)) continue;
            keepCounting = false;
        }
        return false;
    }

    private boolean isThereVerbAfterList(AnalyzedTokenReadings[] tokens, int i, List<String> lemmas) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchLemmaList(tokens[i + j], lemmas)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i + j], PREP_VERB_PRONOM);
            ++j;
        }
        return false;
    }

    private boolean isThereRedundantPronoun(AnalyzedTokenReadings[] tokens, int i) {
        return this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_1S) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_1S) || this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_2S) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_2S) || this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_3S_TOTS) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_3S_TOTS) || this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_1P) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_1P) || this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_2P) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_2P) || this.isThereAfterWithoutPreposition(tokens, i, PRONOM_FEBLE_3P) && this.isThereBeforePostag(tokens, i, PRONOM_FEBLE_3P);
    }

    private boolean isThereNearLemma(AnalyzedTokenReadings[] tokens, int i, List<String> lemmas) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (this.matchLemmaList(tokens[i + j], lemmas)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i + j], TRENCA_COMPTE);
            ++j;
        }
        j = 1;
        keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchLemmaList(tokens[i - j], lemmas)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], TRENCA_COMPTE);
            ++j;
        }
        return false;
    }

    private boolean isThereNearWord(AnalyzedTokenReadings[] tokens, int i, List<String> words) {
        int j = 1;
        boolean keepCounting = true;
        while (i + j < tokens.length && keepCounting) {
            if (words.contains(tokens[i + j].getToken().toLowerCase())) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i + j], TRENCA_COMPTE);
            ++j;
        }
        j = 1;
        keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (words.contains(tokens[i - j].getToken().toLowerCase())) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], TRENCA_COMPTE);
            ++j;
        }
        return false;
    }

    private boolean isTherePersonalSubjectBefore(AnalyzedTokenReadings[] tokens, int i, Pattern pTrenca) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchRegexp(tokens[i - j].getToken(), SUBJECTE_PERSONAL_TOKEN) || this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_POSTAG) && !this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_POSTAG) && !this.matchLemmaRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_LEMMA)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], pTrenca);
            ++j;
        }
        return false;
    }

    private boolean isThereSingularPersonalSubjectBefore(AnalyzedTokenReadings[] tokens, int i, Pattern pTrenca) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchRegexp(tokens[i - j].getToken(), SUBJECTE_PERSONAL_SING_TOKEN) || this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_SING_POSTAG) && !this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_POSTAG) && !this.matchLemmaRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_LEMMA)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], pTrenca);
            ++j;
        }
        return false;
    }

    private boolean isTherePluralPersonalSubjectBefore(AnalyzedTokenReadings[] tokens, int i, Pattern pTrenca) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchRegexp(tokens[i - j].getToken(), SUBJECTE_PERSONAL_PL_TOKEN) || this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_PL_POSTAG) && !this.matchPostagRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_POSTAG) && !this.matchLemmaRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_LEMMA)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], pTrenca);
            ++j;
        }
        return false;
    }

    private boolean isThereSubject3SBefore(AnalyzedTokenReadings[] tokens, int i, Pattern pTrenca) {
        int j = 1;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchRegexp(tokens[i - j].getToken(), SUBJECTE_3S_TOKEN) || this.matchPostagRegexp(tokens[i - j], SUBJECTE_3S_POSTAG) && !this.matchPostagRegexp(tokens[i - j], SUBJECTE_3S_NO_POSTAG) && !this.matchRegexp(tokens[i - j].getToken(), SUBJECTE_3S_NO_TOKEN) && !this.matchLemmaRegexp(tokens[i - j], SUBJECTE_PERSONAL_NO_LEMMA)) {
                return true;
            }
            keepCounting = !this.matchPostagRegexp(tokens[i - j], pTrenca);
            ++j;
        }
        return false;
    }

    private boolean isVerbNumberPerson(AnalyzedTokenReadings[] tokens, int i, Pattern pVerb) {
        int j = 0;
        boolean keepCounting = true;
        while (i - j > 0 && keepCounting) {
            if (this.matchPostagRegexp(tokens[i - j], pVerb)) {
                return true;
            }
            keepCounting = this.matchPostagRegexp(tokens[i - j], PREP_VERB_PRONOM);
            if (tokens[i - j].getToken().equalsIgnoreCase("per") && tokens[i - j + 1].getToken().equalsIgnoreCase("a")) {
                keepCounting = false;
            }
            ++j;
        }
        return false;
    }

    private boolean isPhraseImpersonalVerbS(AnalyzedTokenReadings[] tokens, int i) {
        return this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && !this.isThereBefore(tokens, i, LEMMA_PRONOM_CI, POSTAG_PRONOM_CI) && (!this.isThereSingularPersonalSubjectBefore(tokens, i, TRENCA_COMPTE2) || this.isThereBefore(tokens, i, LEMMA_HI, POSTAG_HI)) && this.isVerbNumberPerson(tokens, i, VERB_3S);
    }

    private boolean isPhraseImpersonalVerbSP(AnalyzedTokenReadings[] tokens, int i) {
        return this.isThereBefore(tokens, i, LEMMA_ES, POSTAG_ES) && !this.isThereBefore(tokens, i, LEMMA_PRONOM_CI, POSTAG_PRONOM_CI) && (this.isVerbNumberPerson(tokens, i, VERB_3S) && !this.isThereSingularPersonalSubjectBefore(tokens, i, TRENCA_COMPTE) || this.isVerbNumberPerson(tokens, i, VERB_3P) && !this.isTherePluralPersonalSubjectBefore(tokens, i, TRENCA_COMPTE) || this.isThereBefore(tokens, i, LEMMA_HI, POSTAG_HI));
    }

    public void reset() {
    }
}

