/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.core.internal.mock;

import org.kubek2k.springockito.annotations.internal.MockitoMockSettings;
import org.kubek2k.springockito.core.internal.ResettableSpringockito;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFactorySpringockito<T>
implements FactoryBean<T>,
ResettableSpringockito {
    protected Class<T> mockClass;
    protected MockitoMockSettings mockitoMockSettings;
    protected T instance;

    public Class<? extends T> getObjectType() {
        return this.mockClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public T getObject() throws Exception {
        if (this.instance == null) {
            this.instance = Mockito.mock(this.mockClass, (MockSettings)this.getMockSettings());
        }
        return this.instance;
    }

    private MockSettings getMockSettings() {
        if (this.mockitoMockSettings == null) {
            this.mockitoMockSettings = MockitoMockSettings.DEFAULT;
        }
        return this.mockitoMockSettings.getMockSettings();
    }

    public void setMockClass(Class<T> mockClass) {
        this.mockClass = mockClass;
    }

    public void setMockitoMockSettings(MockitoMockSettings mockitoMockSettings) {
        this.mockitoMockSettings = mockitoMockSettings;
    }

    @Override
    public void reset() {
        try {
            Mockito.reset((Object[])new Object[]{this.getObject()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

