/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations.internal;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.kubek2k.springockito.annotations.ReplaceWithMock;
import org.kubek2k.springockito.annotations.WrapWithSpy;
import org.kubek2k.springockito.annotations.internal.definitions.MockDefinition;
import org.kubek2k.springockito.annotations.internal.definitions.SpringockitoDefinition;
import org.kubek2k.springockito.annotations.internal.definitions.SpyDefinition;
import org.kubek2k.springockito.annotations.internal.naming.BeanNameResolver;
import org.kubek2k.springockito.annotations.internal.naming.BeanNameResolverChainOfResponsibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringockitoDefinitionFinder {
    private BeanNameResolver beanNameResolver = new BeanNameResolverChainOfResponsibility();

    public Set<SpringockitoDefinition> findSpringockitoDefinitions(Class<?> clazz) {
        HashSet<SpringockitoDefinition> result = new HashSet<SpringockitoDefinition>();
        while (clazz != null) {
            result.addAll(this.findDefinitions(clazz));
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private Set<SpringockitoDefinition> findDefinitions(Class<?> currentClass) {
        HashSet<SpringockitoDefinition> definitions = new HashSet<SpringockitoDefinition>();
        for (Field field : currentClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(ReplaceWithMock.class)) {
                definitions.add(this.newMockDefinition(field));
                continue;
            }
            if (!field.isAnnotationPresent(WrapWithSpy.class)) continue;
            definitions.add(this.newSpyDefinition(field));
        }
        return definitions;
    }

    private SpyDefinition newSpyDefinition(Field field) {
        return (SpyDefinition)new SpyDefinition().withTargetBeanName(this.resolveBeanName(field));
    }

    private MockDefinition newMockDefinition(Field field) {
        return (MockDefinition)new MockDefinition().withAnnotationInstance(field.getAnnotation(ReplaceWithMock.class)).withMockClass(field.getType()).withTargetBeanName(this.resolveBeanName(field));
    }

    private String resolveBeanName(Field field) {
        return this.beanNameResolver.retrieveBeanName(field);
    }
}

