/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations.internal;

import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.internal.creation.MockSettingsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoMockSettings {
    public static final MockitoMockSettings DEFAULT = new MockitoMockSettings();
    private Class<?>[] extraInterfaces;
    private String mockName;
    private Answers defaultAnswer;

    public MockSettings getMockSettings() {
        return this.createMockSettings();
    }

    private MockSettings createMockSettings() {
        MockSettingsImpl mockSettings = new MockSettingsImpl();
        if (this.extraInterfaces != null && this.extraInterfaces.length > 0) {
            mockSettings.extraInterfaces((Class[])this.extraInterfaces);
        }
        if (this.defaultAnswer != null) {
            mockSettings.defaultAnswer(this.defaultAnswer.get());
        } else {
            mockSettings.defaultAnswer(Answers.RETURNS_DEFAULTS.get());
        }
        if (this.mockName != null) {
            mockSettings.name(this.mockName);
        }
        return mockSettings;
    }

    public MockitoMockSettings withExtraInterfaces(Class<?>[] extraInterfaces) {
        this.extraInterfaces = extraInterfaces;
        return this;
    }

    public MockitoMockSettings withMockName(String mockName) {
        this.mockName = mockName;
        return this;
    }

    public MockitoMockSettings withDefaultAnswer(Answers defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
        return this;
    }
}

