/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.kopitubruk.util.json.FastStringCollection;

class ReflectionData {
    private Class<?> clazz;
    private int privacyLevel;
    private FastStringCollection fieldNames;
    private TreeMap<String, String> fieldAliases;
    private String[] names;
    private Member[] attributes;

    ReflectionData(Class<?> clazz, int privacyLevel, FastStringCollection fieldNames, TreeMap<String, String> fieldAliases, String[] names, Member[] attributes) {
        this(clazz, privacyLevel, fieldNames, fieldAliases);
        this.names = names;
        this.attributes = attributes;
    }

    ReflectionData(Class<?> clazz, int privacyLevel, FastStringCollection fieldNames, TreeMap<String, String> fieldAliases) {
        this.clazz = clazz;
        this.privacyLevel = privacyLevel;
        this.fieldNames = fieldNames;
        this.fieldAliases = fieldAliases;
    }

    String[] getNames() {
        return this.names;
    }

    Member[] getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + this.clazz.hashCode();
        hashCode = 31 * hashCode + this.privacyLevel;
        hashCode = 31 * hashCode + (this.fieldNames == null ? 0 : this.fieldNames.hashCode());
        hashCode = 31 * hashCode + this.aliasesHashCode();
        return hashCode;
    }

    private int aliasesHashCode() {
        if (this.fieldAliases == null) {
            return 0;
        }
        int result = 1;
        for (Map.Entry<String, String> entry : this.fieldAliases.entrySet()) {
            result = 31 * result + entry.getKey().hashCode();
            result = 31 * result + entry.getValue().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        ReflectionData other = (ReflectionData)obj;
        if (this.clazz != other.clazz) {
            return false;
        }
        if (this.privacyLevel != other.privacyLevel) {
            return false;
        }
        if (!this.fieldNamesEqual(other.fieldNames)) {
            return false;
        }
        return this.aliasesEqual(other.fieldAliases);
    }

    private boolean fieldNamesEqual(FastStringCollection fnames) {
        if (this.fieldNames == fnames) {
            return true;
        }
        if (this.fieldNames == null) {
            return false;
        }
        return this.fieldNames.equals(fnames);
    }

    private boolean aliasesEqual(TreeMap<String, String> aliases) {
        if (this.fieldAliases == aliases) {
            return true;
        }
        if (this.fieldAliases == null || aliases == null) {
            return false;
        }
        if (this.fieldAliases.size() != aliases.size()) {
            return false;
        }
        Iterator<Map.Entry<String, String>> iter0 = this.fieldAliases.entrySet().iterator();
        Iterator<Map.Entry<String, String>> iter1 = aliases.entrySet().iterator();
        while (iter0.hasNext()) {
            Map.Entry<String, String> entry0 = iter0.next();
            Map.Entry<String, String> entry1 = iter1.next();
            if (!entry0.getKey().equals(entry1.getKey())) {
                return false;
            }
            if (entry0.getValue().equals(entry1.getValue())) continue;
            return false;
        }
        return true;
    }
}

