/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kopitubruk.util.json.AbstractPseudoMap;
import org.kopitubruk.util.json.DynamicPseudoMap;
import org.kopitubruk.util.json.FastStringCollection;
import org.kopitubruk.util.json.FixedPseudoMap;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONReflectedClass;
import org.kopitubruk.util.json.JSONReflectionException;
import org.kopitubruk.util.json.ReflectUtil;
import org.kopitubruk.util.json.ReflectionData;

class ReflectedObjectMapBuilder {
    private Object propertyValue;
    private JSONConfig cfg;
    private JSONReflectedClass refClass = null;
    private Class<?> clazz;
    private Collection<String> fieldNameList;
    private Set<String> fieldNames;
    private FastStringCollection fnames;
    private Map<String, Field> fields;
    private Map<String, Method> getterMethods;
    private ReflectionData reflectionData;
    private Map<ReflectionData, ReflectionData> reflectionDataCache;
    private int privacyLevel;
    private boolean cacheReflectionData;
    private boolean isFieldsSpecified;
    private boolean isPrivate;
    private static volatile Map<ReflectionData, ReflectionData> REFLECTION_DATA_CACHE;

    ReflectedObjectMapBuilder(Object propertyValue, JSONConfig cfg) {
        this.propertyValue = propertyValue;
        this.cfg = cfg;
    }

    Map<Object, Object> buildReflectedObjectMap() {
        String name = "buildReflectedObjectMap()";
        try {
            AbstractPseudoMap obj;
            if (this.reflectionData == null) {
                ArrayList<Member> attributeList = null;
                ArrayList<String> nameList = null;
                obj = new DynamicPseudoMap();
                if (this.cacheReflectionData) {
                    attributeList = new ArrayList<Member>();
                    nameList = new ArrayList<String>();
                }
                for (String fieldName : this.fieldNameList) {
                    name = this.refClass.getFieldAlias(fieldName);
                    Field field = this.fields.get(fieldName);
                    Method getter = this.getGetter(field, fieldName);
                    if (getter != null) {
                        ReflectUtil.ensureAccessible(getter);
                        obj.put(name, getter.invoke(this.propertyValue, new Object[0]));
                        if (!this.cacheReflectionData) continue;
                        nameList.add(name);
                        attributeList.add(getter);
                        continue;
                    }
                    if (field != null && this.isVisible(field)) {
                        ReflectUtil.ensureAccessible(field);
                        obj.put(name, field.get(this.propertyValue));
                        if (!this.cacheReflectionData) continue;
                        nameList.add(name);
                        attributeList.add(field);
                        continue;
                    }
                    if (!this.isFieldsSpecified) continue;
                    throw new JSONReflectionException(this.propertyValue, fieldName, this.cfg);
                }
                if (this.cacheReflectionData) {
                    this.addReflectionData(attributeList, nameList);
                }
            } else {
                String[] names = this.reflectionData.getNames();
                Member[] attributes = this.reflectionData.getAttributes();
                obj = new FixedPseudoMap(attributes.length);
                for (int i = 0; i < attributes.length; ++i) {
                    Member attribute = attributes[i];
                    name = names[i];
                    if (attribute instanceof Method) {
                        obj.put(name, ((Method)attribute).invoke(this.propertyValue, new Object[0]));
                        continue;
                    }
                    obj.put(name, ((Field)attribute).get(this.propertyValue));
                }
            }
            return obj;
        }
        catch (JSONReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONReflectionException(this.propertyValue, name, e, this.cfg);
        }
    }

    void init() {
        try {
            this.refClass = this.cfg.ensureReflectedClass(this.propertyValue);
            this.clazz = this.refClass.getObjClass();
            this.fieldNames = this.refClass.getFieldNamesRaw();
            this.isFieldsSpecified = this.fieldNames != null;
            this.privacyLevel = this.isFieldsSpecified ? 0 : this.cfg.getReflectionPrivacy();
            this.cacheReflectionData = this.cfg.isCacheReflectionData();
            if (this.cacheReflectionData) {
                this.fnames = this.isFieldsSpecified ? new FastStringCollection(this.fieldNames) : null;
                TreeMap<String, String> fieldAliases = this.refClass.getFieldAliasesTreeMap();
                this.reflectionDataCache = ReflectedObjectMapBuilder.getReflectionDataCache();
                this.reflectionData = this.reflectionDataCache.get(new ReflectionData(this.clazz, this.privacyLevel, this.fnames, fieldAliases));
            } else {
                this.reflectionData = null;
            }
            if (this.reflectionData == null) {
                boolean bl = this.isPrivate = this.privacyLevel == 0;
                if (this.isFieldsSpecified) {
                    this.initSpecifiedFields();
                } else {
                    this.initFields();
                }
                this.initGetterMethods();
            }
        }
        catch (Exception e) {
            throw new JSONReflectionException(this.propertyValue, "init()", e, this.cfg);
        }
    }

    private void initSpecifiedFields() {
        HashSet<String> allFieldNames = new HashSet<String>();
        this.fields = new HashMap<String, Field>(this.fieldNames.size());
        this.fieldNameList = this.cacheReflectionData ? this.fnames : this.fieldNames;
        for (Class<?> tmpClass = this.clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Field field : tmpClass.getDeclaredFields()) {
                String name = field.getName();
                if (allFieldNames.contains(name)) continue;
                allFieldNames.add(name);
                if (!this.fieldNames.contains(name)) continue;
                this.fields.put(name, field);
            }
        }
    }

    private void initFields() {
        HashSet<String> allFieldNames = new HashSet<String>();
        this.fieldNameList = new ArrayList<String>();
        this.fields = new HashMap<String, Field>();
        for (Class<?> tmpClass = this.clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Field field : tmpClass.getDeclaredFields()) {
                String name = field.getName();
                if (allFieldNames.contains(name)) continue;
                allFieldNames.add(name);
                if (!ReflectUtil.isSerializable(field)) continue;
                this.fieldNameList.add(name);
                this.fields.put(name, field);
            }
        }
    }

    private void initGetterMethods() {
        this.getterMethods = new HashMap<String, Method>();
        for (Class<?> tmpClass = this.clazz; tmpClass != null; tmpClass = tmpClass.getSuperclass()) {
            for (Method method : tmpClass.getDeclaredMethods()) {
                String name;
                Class<?> retType;
                if (method.getParameterTypes().length != 0 || Void.TYPE == (retType = method.getReturnType()) || this.getterMethods.containsKey(name = method.getName()) || !ReflectUtil.isGetterName(name, retType) || !this.isVisible(method)) continue;
                this.getterMethods.put(name, method);
            }
        }
    }

    private Method getGetter(Field field, String name) {
        Method getter = this.getterMethods.get(ReflectUtil.makeBeanMethodName(name, "get"));
        if (getter == null) {
            getter = this.getterMethods.get(ReflectUtil.makeBeanMethodName(name, "is"));
        }
        if (field == null || getter == null) {
            return getter;
        }
        return ReflectUtil.isCompatibleInJSON(field, getter) ? getter : null;
    }

    private boolean isVisible(Member member) {
        return this.isPrivate || ReflectUtil.getPrivacyLevel(member.getModifiers()) >= this.privacyLevel;
    }

    private void addReflectionData(List<Member> attributeList, List<String> nameList) {
        FastStringCollection cachedFieldNames = this.isFieldsSpecified ? this.fnames : null;
        TreeMap<String, String> fieldAliases = this.refClass.getFieldAliasesTreeMap();
        if (fieldAliases != null) {
            fieldAliases = new TreeMap<String, String>((SortedMap<String, String>)fieldAliases);
        }
        String[] names = nameList.toArray(new String[nameList.size()]);
        Member[] attributes = attributeList.toArray(new Member[attributeList.size()]);
        this.reflectionData = new ReflectionData(this.clazz, this.privacyLevel, cachedFieldNames, fieldAliases, names, attributes);
        this.reflectionDataCache.put(this.reflectionData, this.reflectionData);
    }

    static synchronized void clearReflectionCache() {
        REFLECTION_DATA_CACHE = null;
    }

    private static synchronized Map<ReflectionData, ReflectionData> getReflectionDataCache() {
        if (REFLECTION_DATA_CACHE == null) {
            REFLECTION_DATA_CACHE = new Hashtable<ReflectionData, ReflectionData>(0);
        }
        return REFLECTION_DATA_CACHE;
    }

    static {
        ReflectedObjectMapBuilder.clearReflectionCache();
    }
}

