/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONParser;
import org.kopitubruk.util.json.JSONParserException;

class JSONTokenReader {
    private static final Map<Character, JSONParser.Token> SIMPLE_TOKENS;
    private JSONParser.Token extraToken = null;
    private Reader json;
    private JSONConfig cfg;
    private long charCount = 0L;

    JSONTokenReader(Reader json, JSONConfig cfg) {
        this.json = json;
        this.cfg = cfg;
    }

    JSONConfig getJSONConfig() {
        return this.cfg;
    }

    JSONParser.Token nextToken() throws IOException {
        if (this.extraToken != null) {
            JSONParser.Token result = this.extraToken;
            this.extraToken = null;
            return result;
        }
        int codePoint = this.nextCodePoint();
        while (codePoint >= 0 && Character.isWhitespace(codePoint)) {
            codePoint = this.nextCodePoint();
        }
        if (codePoint < 0) {
            return null;
        }
        char ch = codePoint <= 65535 ? (char)codePoint : (char)'\u0000';
        switch (ch) {
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return SIMPLE_TOKENS.get(Character.valueOf(ch));
            }
            case '\"': 
            case '\'': {
                return new JSONParser.Token(JSONParser.TokenType.STRING, this.getQuotedString(ch));
            }
        }
        return this.matchOthers(this.getOtherTokenString(codePoint));
    }

    private String getOtherTokenString(int codePoint) throws IOException {
        StringBuilder buf = new StringBuilder();
        int escapeCount = 0;
        do {
            char ch;
            char c = ch = codePoint <= 65535 ? (char)codePoint : (char)'\u0000';
            if (ch == '\\') {
                ++escapeCount;
                buf.append(ch);
                continue;
            }
            if ((ch == '\'' || ch == '\"') && escapeCount % 2 == 0) {
                buf.append(ch).append(this.getQuotedString(ch)).append(ch);
                escapeCount = 0;
                continue;
            }
            this.extraToken = SIMPLE_TOKENS.get(Character.valueOf(ch));
            if (this.extraToken != null) break;
            buf.appendCodePoint(codePoint);
            escapeCount = 0;
        } while ((codePoint = this.nextCodePoint()) >= 0);
        return buf.toString().trim();
    }

    private JSONParser.Token matchOthers(String str) {
        Matcher matcher = JSONParser.NEW_DATE_PAT.matcher(str);
        if (matcher.matches()) {
            String qs = matcher.group(2);
            return new JSONParser.Token(JSONParser.TokenType.DATE, qs.substring(1, qs.length() - 1));
        }
        matcher = JSONParser.JAVASCRIPT_FLOATING_POINT_PAT.matcher(str);
        if (matcher.matches()) {
            String number = matcher.group(1);
            return new JSONParser.Token(JSONParser.TokenType.FLOATING_POINT_NUMBER, number);
        }
        matcher = JSONParser.JAVASCRIPT_INTEGER_PAT.matcher(str);
        if (matcher.matches()) {
            String number = matcher.group(1);
            return new JSONParser.Token(JSONParser.TokenType.INTEGER_NUMBER, number);
        }
        matcher = JSONParser.LITERAL_PAT.matcher(str);
        if (matcher.matches()) {
            String literal = matcher.group(1);
            return new JSONParser.Token(JSONParser.TokenType.LITERAL, literal);
        }
        matcher = JSONParser.UNQUOTED_ID_PAT.matcher(str);
        if (matcher.matches()) {
            String id = matcher.group(0);
            return new JSONParser.Token(JSONParser.TokenType.UNQUOTED_ID, id);
        }
        throw new JSONParserException(str, this.charCount, this.cfg);
    }

    private String getQuotedString(char q) throws IOException {
        StringBuilder str = new StringBuilder();
        int escapeCount = 0;
        while (true) {
            int nextChar;
            if ((nextChar = this.json.read()) < 0) {
                throw new JSONParserException(q, this.cfg);
            }
            ++this.charCount;
            char ch = (char)nextChar;
            if (ch == '\\') {
                ++escapeCount;
                str.append(ch);
                continue;
            }
            if (ch == q) {
                if (escapeCount % 2 == 0) break;
                str.append(ch);
                escapeCount = 0;
                continue;
            }
            str.append(ch);
            escapeCount = 0;
        }
        return str.toString();
    }

    private int nextCodePoint() throws IOException {
        int codePoint = this.json.read();
        if (codePoint >= 0) {
            if (Character.isHighSurrogate((char)codePoint)) {
                int ch = this.json.read();
                if (ch >= 0 && Character.isLowSurrogate((char)ch)) {
                    codePoint = Character.toCodePoint((char)codePoint, (char)ch);
                } else {
                    throw new JSONParserException(codePoint, ch, this.charCount, this.cfg);
                }
            }
            this.charCount += (long)Character.charCount(codePoint);
        }
        return codePoint;
    }

    static {
        HashMap<Character, JSONParser.Token> simpleTokens = new HashMap<Character, JSONParser.Token>();
        simpleTokens.put(Character.valueOf('{'), new JSONParser.Token(JSONParser.TokenType.START_OBJECT, null));
        simpleTokens.put(Character.valueOf('}'), new JSONParser.Token(JSONParser.TokenType.END_OBJECT, null));
        simpleTokens.put(Character.valueOf('['), new JSONParser.Token(JSONParser.TokenType.START_ARRAY, null));
        simpleTokens.put(Character.valueOf(']'), new JSONParser.Token(JSONParser.TokenType.END_ARRAY, null));
        simpleTokens.put(Character.valueOf(','), new JSONParser.Token(JSONParser.TokenType.COMMA, null));
        simpleTokens.put(Character.valueOf(':'), new JSONParser.Token(JSONParser.TokenType.COLON, null));
        SIMPLE_TOKENS = new HashMap<Character, JSONParser.Token>(simpleTokens);
    }
}

