/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Locale;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONParser;
import org.kopitubruk.util.json.JSONUtil;

public class JSONParserException
extends JSONException {
    private String badData = null;
    private Character quote = null;
    private Exception e = null;
    private JSONParser.TokenType expectedTokenType = null;
    private JSONParser.TokenType tokenType = null;
    private long index = 0L;
    private int high = 0;
    private int low = 0;
    private boolean malformedCodePoint = false;
    private static final long serialVersionUID = 1L;

    JSONParserException(String bd, long idx, JSONConfig cfg) {
        super(cfg);
        this.badData = bd;
        this.index = idx;
    }

    JSONParserException(char q, JSONConfig cfg) {
        super(cfg);
        this.quote = Character.valueOf(q);
    }

    JSONParserException(JSONParser.TokenType ett, JSONParser.TokenType tt, JSONConfig cfg) {
        super(cfg);
        this.expectedTokenType = ett;
        this.tokenType = tt;
    }

    JSONParserException(Exception e, JSONConfig cfg) {
        super(e, cfg);
        this.e = e;
    }

    JSONParserException(int high, int low, long idx, JSONConfig cfg) {
        super(cfg);
        this.index = idx;
        this.malformedCodePoint = true;
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        if (this.quote != null) {
            return String.format(bundle.getString("unclosedQuote"), this.quote);
        }
        if (this.expectedTokenType != null) {
            switch (this.expectedTokenType) {
                case COLON: {
                    return String.format(bundle.getString("expectedColon"), String.valueOf((Object)this.tokenType));
                }
                case END_OBJECT: {
                    return String.format(bundle.getString("expectedIdentifier"), String.valueOf((Object)this.tokenType));
                }
            }
            return String.format(bundle.getString("expectedValue"), String.valueOf((Object)this.tokenType));
        }
        if (this.malformedCodePoint) {
            return String.format(bundle.getString("malformedCodePoint"), this.high, this.low, this.index);
        }
        if (this.e != null) {
            return this.e.getLocalizedMessage();
        }
        String str = this.badData == null ? "" : this.badData;
        return String.format(bundle.getString("unrecognizedData"), this.index, str);
    }
}

