/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONConfigUtil;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONParserException;
import org.kopitubruk.util.json.JSONTokenReader;
import org.kopitubruk.util.json.JSONUtil;
import org.kopitubruk.util.json.StringProcessor;

public class JSONParser {
    static final Pattern LITERAL_PAT = Pattern.compile("^(null|true|false)$");
    private static final Pattern OCTAL_PAT = Pattern.compile("^0[0-7]*$");
    static final Pattern UNQUOTED_ID_PAT = JSONUtil.VALID_ECMA6_PROPERTY_NAME_PAT;
    static final Pattern JAVASCRIPT_FLOATING_POINT_PAT = Pattern.compile("^((?:[-+]?(?:(?:\\d+\\.\\d+|\\.\\d+)(?:[eE][-+]?\\d+)?|Infinity))|NaN)$");
    static final Pattern JAVASCRIPT_INTEGER_PAT = Pattern.compile("^([-+]?(?:\\d+|0[xX][\\da-fA-F]+))$");
    static final Pattern NEW_DATE_PAT = Pattern.compile("^(new\\s+Date\\s*\\(\\s*('[^']+'|\"[^\"]+\")\\s*\\))$");
    private static final Pattern TZ_PAT = Pattern.compile("^(.+)(([-+]\\d{2})(?::(\\d{2}))?|Z)$");
    private static final Pattern ISO8601_PAT = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}([,\\.]\\d+)?$");
    private static final int MAX_PRECISION_FOR_FLOAT = 9;
    private static final int MAX_PRECISION_FOR_DOUBLE = 17;
    private static final int MAX_PRECISION_FOR_LONG = 19;

    public static Object parseJSON(String json) {
        return JSONParser.parseJSON(json, null);
    }

    public static Object parseJSON(String json, JSONConfig cfg) {
        try {
            return JSONParser.parseJSON(new StringReader(json), cfg);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Object parseJSON(Reader json) throws IOException {
        return JSONParser.parseJSON(json, null);
    }

    public static Object parseJSON(Reader json, JSONConfig cfg) throws IOException {
        JSONConfig jcfg = cfg == null ? new JSONConfig() : cfg;
        JSONTokenReader tokens = new JSONTokenReader(json, jcfg);
        try {
            return JSONParser.parseTokens(tokens.nextToken(), tokens);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONParserException(e, jcfg);
        }
    }

    private static Object parseTokens(Token token, JSONTokenReader tokens) throws IOException, ParseException {
        if (token == null) {
            return null;
        }
        switch (token.tokenType) {
            case START_OBJECT: {
                return JSONParser.parseObject(tokens);
            }
            case START_ARRAY: {
                return JSONParser.parseArray(tokens);
            }
        }
        return JSONParser.getValue(token, tokens);
    }

    private static Map<?, ?> parseObject(JSONTokenReader tokens) throws IOException, ParseException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        JSONConfig cfg = tokens.getJSONConfig();
        Token token = tokens.nextToken();
        while (token != null) {
            String key;
            if (token.tokenType == TokenType.STRING || token.tokenType == TokenType.UNQUOTED_ID) {
                key = StringProcessor.unEscape(token.value, cfg);
                token = tokens.nextToken();
                if (token.tokenType != TokenType.COLON) {
                    throw new JSONParserException(TokenType.COLON, token.tokenType, cfg);
                }
            } else {
                if (token.tokenType == TokenType.END_OBJECT) break;
                throw new JSONParserException(TokenType.END_OBJECT, token.tokenType, cfg);
            }
            token = tokens.nextToken();
            map.put(key, JSONParser.getValue(token, tokens));
            token = tokens.nextToken();
            if (token.tokenType == TokenType.END_OBJECT) break;
            if (token.tokenType == TokenType.COMMA) {
                token = tokens.nextToken();
                continue;
            }
            throw new JSONParserException(TokenType.END_OBJECT, token.tokenType, cfg);
        }
        return JSONConfigUtil.tableSizeFor(map.size()) < 16 ? new LinkedHashMap<String, Object>(map) : map;
    }

    private static Object parseArray(JSONTokenReader tokens) throws IOException, ParseException {
        Object array;
        ArrayList<Object> list = new ArrayList<Object>();
        JSONConfig cfg = tokens.getJSONConfig();
        Token token = tokens.nextToken();
        while (token != null && token.tokenType != TokenType.END_ARRAY) {
            list.add(JSONParser.getValue(token, tokens));
            token = tokens.nextToken();
            if (token.tokenType == TokenType.END_ARRAY) break;
            if (token.tokenType == TokenType.COMMA) {
                token = tokens.nextToken();
                continue;
            }
            throw new JSONParserException(TokenType.END_ARRAY, token.tokenType, cfg);
        }
        list.trimToSize();
        if (cfg.isUsePrimitiveArrays() && (array = JSONParser.getArrayOfPrimitives(list, cfg.isSmallNumbers())) != null) {
            return array;
        }
        return list;
    }

    private static Object getValue(Token token, JSONTokenReader tokens) throws ParseException, IOException {
        JSONConfig cfg = tokens.getJSONConfig();
        switch (token.tokenType) {
            case STRING: {
                String unesc = StringProcessor.unEscape(token.value, cfg);
                if (cfg.isFormatDates()) {
                    try {
                        return JSONParser.parseDate(unesc, cfg);
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (cfg.isEncodeNumericStringsAsNumbers()) {
                    Matcher matcher = JAVASCRIPT_FLOATING_POINT_PAT.matcher(unesc);
                    if (matcher.matches()) {
                        return JSONParser.getDecimal(matcher.group(1), cfg.isSmallNumbers());
                    }
                    matcher = JAVASCRIPT_INTEGER_PAT.matcher(unesc);
                    if (matcher.matches()) {
                        return JSONParser.getInteger(matcher.group(1), cfg.isSmallNumbers());
                    }
                }
                return unesc;
            }
            case FLOATING_POINT_NUMBER: {
                return JSONParser.getDecimal(token.value, cfg.isSmallNumbers());
            }
            case INTEGER_NUMBER: {
                return JSONParser.getInteger(token.value, cfg.isSmallNumbers());
            }
            case LITERAL: {
                if (token.value.equals("null")) {
                    return null;
                }
                return Boolean.valueOf(token.value);
            }
            case DATE: {
                return JSONParser.parseDate(StringProcessor.unEscape(token.value, cfg), cfg);
            }
            case START_OBJECT: 
            case START_ARRAY: {
                return JSONParser.parseTokens(token, tokens);
            }
        }
        throw new JSONParserException(TokenType.STRING, token.tokenType, cfg);
    }

    /*
     * WARNING - void declaration
     */
    private static Object getArrayOfPrimitives(ArrayList<Object> list, boolean smallNumbers) {
        void var12_43;
        Number num;
        if (list.size() < 1) {
            return null;
        }
        boolean haveNumber = false;
        boolean haveBoolean = false;
        boolean haveChar = false;
        for (Object obj : list) {
            if (obj instanceof Number) {
                if (obj instanceof BigInteger || obj instanceof BigDecimal) {
                    return null;
                }
                haveNumber = true;
                continue;
            }
            if (obj instanceof Boolean) {
                haveBoolean = true;
                continue;
            }
            if (obj instanceof String && ((String)obj).length() == 1) {
                haveChar = true;
                continue;
            }
            return null;
        }
        if (haveBoolean) {
            if (haveNumber || haveChar) {
                return null;
            }
            boolean[] booleans = new boolean[list.size()];
            for (int i = 0; i < booleans.length; ++i) {
                booleans[i] = (Boolean)list.get(i);
            }
            return booleans;
        }
        if (haveChar) {
            if (haveNumber) {
                return null;
            }
            char[] chars = new char[list.size()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = ((String)list.get(i)).charAt(0);
            }
            return chars;
        }
        boolean haveDouble = false;
        boolean haveFloat = false;
        boolean haveLong = false;
        boolean haveInt = false;
        boolean haveShort = false;
        ArrayList<Number> workList = new ArrayList<Number>(list.size());
        for (Object object : list) {
            workList.add((Number)object);
        }
        if (smallNumbers) {
            for (Number number : workList) {
                haveDouble = haveDouble || number instanceof Double;
                haveFloat = haveFloat || number instanceof Float;
                haveLong = haveLong || number instanceof Long;
                haveInt = haveInt || number instanceof Integer;
                haveShort = haveShort || number instanceof Short;
            }
        } else {
            smallNumbers = true;
            int n = workList.size();
            for (int i = 0; i < n; ++i) {
                num = (Number)workList.get(i);
                Number x = JSONParser.getDecimal(num.toString(), smallNumbers);
                if (!(num.getClass().equals(x.getClass()) || x instanceof BigDecimal || x instanceof BigInteger)) {
                    num = x;
                    workList.set(i, num);
                }
                haveDouble = haveDouble || num instanceof Double;
                haveFloat = haveFloat || num instanceof Float;
                haveLong = haveLong || num instanceof Long;
                haveInt = haveInt || num instanceof Integer;
                haveShort = haveShort || num instanceof Short;
            }
        }
        if (haveLong && (haveFloat || haveDouble)) {
            int i;
            haveFloat = false;
            haveDouble = false;
            int n = workList.size();
            for (i = 0; i < n && !haveDouble; ++i) {
                long x;
                double y;
                num = (Number)workList.get(i);
                if (num instanceof Float) {
                    long x2;
                    float y2;
                    float f = ((Float)num).floatValue();
                    if (f == (y2 = (float)(x2 = (long)f))) {
                        workList.set(i, x2);
                        continue;
                    }
                    haveDouble = true;
                    continue;
                }
                if (!(num instanceof Double)) continue;
                double d = (Double)num;
                if (d == (y = (double)(x = (long)d))) {
                    workList.set(i, x);
                    continue;
                }
                haveDouble = true;
            }
            if (haveDouble) {
                int n2 = workList.size();
                for (i = 0; i < n2; ++i) {
                    double d;
                    long y;
                    num = (Number)workList.get(i);
                    if (!(num instanceof Long)) continue;
                    long x = (Long)num;
                    if (x == (y = (long)(d = (double)x))) {
                        workList.set(i, d);
                        continue;
                    }
                    return null;
                }
            }
        }
        if (haveInt && haveFloat && !haveDouble) {
            int n = workList.size();
            for (int i = 0; i < n && !haveDouble; ++i) {
                float f;
                int y;
                num = (Number)workList.get(i);
                if (!(num instanceof Integer)) continue;
                int x = (Integer)num;
                haveDouble = x != (y = (int)(f = (float)x));
            }
        }
        if (haveDouble) {
            void var12_33;
            double[] doubles = new double[workList.size()];
            boolean bl = false;
            while (var12_33 < doubles.length) {
                num = (Number)workList.get((int)var12_33);
                doubles[var12_33] = num instanceof Float ? Double.parseDouble(num.toString()) : num.doubleValue();
                ++var12_33;
            }
            return doubles;
        }
        if (haveFloat) {
            void var12_35;
            float[] floats = new float[workList.size()];
            boolean bl = false;
            while (var12_35 < floats.length) {
                floats[var12_35] = ((Number)workList.get((int)var12_35)).floatValue();
                ++var12_35;
            }
            return floats;
        }
        if (haveLong) {
            void var12_37;
            long[] longs = new long[workList.size()];
            boolean bl = false;
            while (var12_37 < longs.length) {
                longs[var12_37] = ((Number)workList.get((int)var12_37)).longValue();
                ++var12_37;
            }
            return longs;
        }
        if (haveInt) {
            void var12_39;
            int[] ints = new int[workList.size()];
            boolean bl = false;
            while (var12_39 < ints.length) {
                ints[var12_39] = ((Number)workList.get((int)var12_39)).intValue();
                ++var12_39;
            }
            return ints;
        }
        if (haveShort) {
            void var12_41;
            short[] shorts = new short[workList.size()];
            boolean bl = false;
            while (var12_41 < shorts.length) {
                shorts[var12_41] = ((Number)workList.get((int)var12_41)).shortValue();
                ++var12_41;
            }
            return shorts;
        }
        byte[] bytes = new byte[workList.size()];
        boolean bl = false;
        while (var12_43 < bytes.length) {
            bytes[var12_43] = ((Number)workList.get((int)var12_43)).byteValue();
            ++var12_43;
        }
        return bytes;
    }

    private static Number getDecimal(String decimalString, boolean smallNumbers) {
        try {
            Double d;
            Float f;
            BigDecimal bigDec = new BigDecimal(decimalString);
            int scale = bigDec.scale();
            int precision = bigDec.precision();
            if (smallNumbers && scale <= 0 && precision - scale <= 19) {
                try {
                    return JSONParser.getInteger(Long.toString(bigDec.longValueExact()), smallNumbers);
                }
                catch (ArithmeticException e) {
                    // empty catch block
                }
            }
            if (smallNumbers && precision <= 9 && !Float.isInfinite((f = Float.valueOf(bigDec.floatValue())).floatValue()) && bigDec.compareTo(new BigDecimal(f.toString())) == 0) {
                return f;
            }
            if (precision <= 17 && !Double.isInfinite(d = Double.valueOf(bigDec.doubleValue())) && bigDec.compareTo(new BigDecimal(d.toString())) == 0) {
                return d;
            }
            if (!smallNumbers && scale <= 0 && precision - scale <= 19) {
                try {
                    return bigDec.longValueExact();
                }
                catch (ArithmeticException e) {
                    // empty catch block
                }
            }
            if (smallNumbers && scale == 0) {
                return bigDec.toBigIntegerExact();
            }
            return bigDec;
        }
        catch (NumberFormatException e) {
            return smallNumbers ? (double)Float.valueOf(decimalString).floatValue() : Double.valueOf(decimalString);
        }
    }

    private static Number getInteger(String integerString, boolean smallNumbers) {
        BigInteger bigInt = integerString.startsWith("0x") || integerString.startsWith("0X") ? new BigInteger(integerString.substring(2), 16) : (OCTAL_PAT.matcher(integerString).matches() ? new BigInteger(integerString, 8) : new BigInteger(integerString));
        BigDecimal bigDec = new BigDecimal(bigInt);
        if (smallNumbers) {
            try {
                return bigDec.byteValueExact();
            }
            catch (ArithmeticException e) {
                try {
                    return bigDec.shortValueExact();
                }
                catch (ArithmeticException e2) {
                    try {
                        return bigDec.intValueExact();
                    }
                    catch (ArithmeticException e3) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            return bigDec.longValueExact();
        }
        catch (ArithmeticException e) {
            return bigInt;
        }
    }

    private static Date parseDate(String inputStr, JSONConfig cfg) throws ParseException {
        String dateStr = JSONParser.fixTimeZone(inputStr);
        ParseException ex = null;
        for (DateFormat fmt : cfg.getDateParseFormats()) {
            try {
                return fmt.parse(dateStr);
            }
            catch (ParseException e) {
                ex = e;
            }
        }
        throw ex;
    }

    private static String fixTimeZone(String inputStr) {
        String zeroOffset = "+0000";
        Matcher matcher = TZ_PAT.matcher(inputStr);
        if (matcher.find()) {
            String zone = matcher.group(2);
            if ("Z".equals(zone)) {
                zone = zeroOffset;
            } else {
                String minute = matcher.group(4);
                zone = matcher.group(3) + (minute != null ? minute : "00");
            }
            return matcher.group(1) + zone;
        }
        matcher = ISO8601_PAT.matcher(inputStr);
        if (matcher.matches()) {
            return inputStr + zeroOffset;
        }
        return inputStr;
    }

    private JSONParser() {
    }

    static class Token {
        TokenType tokenType;
        String value;

        Token(TokenType tt, String val) {
            this.tokenType = tt;
            this.value = val;
        }
    }

    static enum TokenType {
        START_OBJECT,
        END_OBJECT,
        START_ARRAY,
        END_ARRAY,
        COMMA,
        COLON,
        STRING,
        FLOATING_POINT_NUMBER,
        INTEGER_NUMBER,
        LITERAL,
        UNQUOTED_ID,
        DATE;

    }
}

