/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kopitubruk.util.json.JSONConfigDefaults;

class JNDIUtil {
    private static boolean logging;
    private static LogFactory logFactory;
    private static Log log;
    private static final String ENV_CONTEXT = "java:/comp/env";
    private static final String TOMCAT_URL_PREFIXES = "org.apache.naming";
    private static final String TOMCAT_CONTEXT_FACTORY = ".java.javaURLContextFactory";

    JNDIUtil() {
    }

    private static synchronized void ensureLogger() {
        if (log == null) {
            logFactory = LogFactory.getFactory();
            log = logFactory.getInstance(JSONConfigDefaults.class);
        }
    }

    private static synchronized void releaseLogger() {
        if (log != null) {
            logFactory.release();
            log = null;
            logFactory = null;
        }
    }

    static synchronized void setLogging(boolean logging) {
        JNDIUtil.logging = logging;
    }

    static Context getEnvContext() throws NamingException {
        return (Context)new InitialContext().lookup(ENV_CONTEXT);
    }

    static Context getEnvContext(String path) throws NamingException {
        return (Context)JNDIUtil.getEnvContext().lookup(path);
    }

    static Map<String, Object> getJNDIVariables(Context ctx) throws NamingException {
        HashMap<String, Object> jndiVariables = new HashMap<String, Object>();
        NamingEnumeration<Binding> bindings = ctx.listBindings("");
        if (bindings.hasMore()) {
            boolean doLogging = logging;
            if (doLogging) {
                JNDIUtil.ensureLogger();
                doLogging = log.isDebugEnabled();
                if (!doLogging) {
                    JNDIUtil.releaseLogger();
                }
            }
            while (bindings.hasMore()) {
                try {
                    Binding binding = bindings.next();
                    String name = binding.getName();
                    Object obj = binding.getObject();
                    if (obj == null) continue;
                    if (doLogging) {
                        log.debug((Object)(name + " = " + obj));
                    }
                    jndiVariables.put(name, obj);
                }
                catch (Exception e) {
                    if (!doLogging) break;
                    log.error((Object)"", (Throwable)e);
                    break;
                }
            }
            JNDIUtil.releaseLogger();
        }
        return jndiVariables;
    }

    static boolean getBoolean(Map<String, Object> jndiVariables, String name, boolean defaultValue) {
        String val;
        Object value = jndiVariables.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence && ("true".equalsIgnoreCase(val = value.toString()) || "false".equalsIgnoreCase(val))) {
            return Boolean.parseBoolean(val);
        }
        return defaultValue;
    }

    static String getString(Map<String, Object> jndiVariables, String name, String defaultValue) {
        Object value = jndiVariables.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof CharSequence || value instanceof Character) {
            return value.toString();
        }
        return defaultValue;
    }

    static int getInt(Map<String, Object> jndiVariables, String name, int defaultValue) {
        Object value = jndiVariables.get(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return new BigDecimal(value.toString()).intValueExact();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static Context createContext(String contextName, String factory, String prefixes) throws NamingException {
        InitialContext ctx = null;
        Object result = null;
        String[] parts = contextName.split("/");
        try {
            ctx = new InitialContext();
            ctx.lookup(parts[0]);
        }
        catch (NamingException e) {
            System.setProperty("java.naming.factory.initial", factory);
            System.setProperty("java.naming.factory.url.pkgs", prefixes);
            ctx = new InitialContext();
        }
        StringBuilder ctxNameBuf = new StringBuilder(contextName.length());
        boolean didStart = false;
        for (String part : parts) {
            if (didStart) {
                ctxNameBuf.append('/');
            } else {
                didStart = true;
            }
            ctxNameBuf.append(part);
            String ctxName = ctxNameBuf.toString();
            try {
                ctx.lookup(ctxName);
            }
            catch (NamingException e) {
                result = ctx.createSubcontext(ctxName);
            }
        }
        return result != null && result.toString().equals(contextName) ? result : (Context)ctx.lookup(contextName);
    }

    static Context createContext(String contextName) throws NamingException {
        return JNDIUtil.createContext(contextName, "org.apache.naming.java.javaURLContextFactory", TOMCAT_URL_PREFIXES);
    }

    static Context createEnvContext(String contextName) throws NamingException {
        return JNDIUtil.createContext("java:/comp/env/" + contextName);
    }

    static {
        logFactory = null;
        log = null;
        logging = Boolean.parseBoolean(System.getProperty(JNDIUtil.class.getPackage().getName() + '.' + "logging", "true"));
    }
}

