/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PagedIterator<T>
implements Iterator<T> {
    private T[] currentPage;
    @CheckForNull
    private final Consumer<T> itemInitializer;
    private int nextItemIndex;
    @Nonnull
    protected final Iterator<T[]> base;

    PagedIterator(@Nonnull Iterator<T[]> base, @CheckForNull Consumer<T> itemInitializer) {
        this.base = base;
        this.itemInitializer = itemInitializer;
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.currentPage != null && this.currentPage.length > this.nextItemIndex;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentPage[this.nextItemIndex++];
    }

    public List<T> nextPage() {
        return Arrays.asList(this.nextPageArray());
    }

    private void fetch() {
        if ((this.currentPage == null || this.currentPage.length <= this.nextItemIndex) && this.base.hasNext()) {
            T[] result = Objects.requireNonNull(this.base.next());
            this.wrapUp(result);
            this.currentPage = result;
            this.nextItemIndex = 0;
        }
    }

    protected void wrapUp(T[] page) {
        if (this.itemInitializer != null) {
            for (T item : page) {
                this.itemInitializer.accept(item);
            }
        }
    }

    @Nonnull
    T[] nextPageArray() {
        if (this.currentPage == null) {
            this.fetch();
        } else if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Objects.requireNonNull(this.currentPage);
        T[] r = this.currentPage;
        if (this.nextItemIndex != 0) {
            r = Arrays.copyOfRange(r, this.nextItemIndex, r.length);
        }
        this.nextItemIndex = this.currentPage.length;
        return r;
    }
}

