/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageContentsIterable;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.function.InputStreamFunction;
import org.kohsuke.github.internal.graphql.response.GHGraphQLResponse;

class Requester
extends GitHubRequest.Builder<Requester> {
    final transient GitHubClient client;

    @NonNull
    public static InputStream copyInputStream(InputStream inputStream) throws IOException {
        return new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream));
    }

    Requester(GitHubClient client) {
        this.client = client;
        this.withApiUrl(client.getApiUrl());
    }

    public <T> T fetch(@Nonnull Class<T> type) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> GitHubResponse.parseBody(connectorResponse, type)).body();
    }

    public <T extends GHGraphQLResponse<S>, S> S fetchGraphQL(@Nonnull Class<T> type) throws IOException {
        GHGraphQLResponse response = (GHGraphQLResponse)this.fetch(type);
        if (!response.isSuccessful()) {
            throw new IOException("GraphQL request failed by:" + String.valueOf(response.getErrorMessages()));
        }
        return (S)response.getData();
    }

    public int fetchHttpStatusCode() throws IOException {
        return this.client.sendRequest(this.build(), null).statusCode();
    }

    public <T> T fetchInto(@Nonnull T existingInstance) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> GitHubResponse.parseBody(connectorResponse, existingInstance)).body();
    }

    public <T> T fetchStream(@Nonnull InputStreamFunction<T> handler) throws IOException {
        return this.client.sendRequest(this, connectorResponse -> handler.apply(connectorResponse.bodyStream())).body();
    }

    public void send() throws IOException {
        this.client.sendRequest(this, connectorResponse -> GitHubResponse.getBodyAsString(connectorResponse));
    }

    public void sendGraphQL() throws IOException {
        this.fetchGraphQL(GHGraphQLResponse.ObjectResponse.class);
    }

    public <R> PagedIterable<R> toIterable(Class<R[]> type, Consumer<R> itemInitializer) {
        return new GitHubPageContentsIterable<R>(this.client, this.build(), type, itemInitializer);
    }
}

