/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kohsuke.github.GHAppCreateTokenBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHMarketplaceAccountPlan;
import org.kohsuke.github.GHMarketplacePlanForAccountBuilder;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySelection;
import org.kohsuke.github.GHTargetType;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SearchResult;
import org.kohsuke.github.internal.EnumUtils;

public class GHAppInstallation
extends GHObject {
    @JsonProperty(value="access_tokens_url")
    private String accessTokenUrl;
    private GHUser account;
    @JsonProperty(value="app_id")
    private long appId;
    private List<String> events;
    private String htmlUrl;
    private Map<String, GHPermissionType> permissions;
    @JsonProperty(value="repositories_url")
    private String repositoriesUrl;
    @JsonProperty(value="repository_selection")
    private GHRepositorySelection repositorySelection;
    @JsonProperty(value="single_file_name")
    private String singleFileName;
    private String suspendedAt;
    private GHUser suspendedBy;
    @JsonProperty(value="target_id")
    private long targetId;
    @JsonProperty(value="target_type")
    private GHTargetType targetType;

    public GHAppCreateTokenBuilder createToken() {
        return new GHAppCreateTokenBuilder(this.root(), String.format("/app/installations/%d/access_tokens", this.getId()));
    }

    @Deprecated
    public GHAppCreateTokenBuilder createToken(Map<String, GHPermissionType> permissions) {
        return this.createToken().permissions(permissions);
    }

    public void deleteInstallation() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(String.format("/app/installations/%d", this.getId()), new String[0])).send();
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getAccount() {
        return this.account;
    }

    public long getAppId() {
        return this.appId;
    }

    public List<GHEvent> getEvents() {
        return this.events.stream().map(e -> EnumUtils.getEnumOrDefault(GHEvent.class, e, GHEvent.UNKNOWN)).collect(Collectors.toList());
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public GHMarketplaceAccountPlan getMarketplaceAccount() throws IOException {
        return new GHMarketplacePlanForAccountBuilder(this.root(), this.account.getId()).createRequest();
    }

    public Map<String, GHPermissionType> getPermissions() {
        return Collections.unmodifiableMap(this.permissions);
    }

    public String getRepositoriesUrl() {
        return this.repositoriesUrl;
    }

    public GHRepositorySelection getRepositorySelection() {
        return this.repositorySelection;
    }

    public String getSingleFileName() {
        return this.singleFileName;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getSuspendedAt() {
        return GitHubClient.parseInstant(this.suspendedAt);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getSuspendedBy() {
        return this.suspendedBy;
    }

    public long getTargetId() {
        return this.targetId;
    }

    public GHTargetType getTargetType() {
        return this.targetType;
    }

    @Deprecated
    public PagedSearchIterable<GHRepository> listRepositories() {
        GitHubRequest request = ((Requester)this.root().createRequest().withUrlPath("/installation/repositories", new String[0])).build();
        return new PagedSearchIterable<GHRepository>(this.root(), request, GHAppInstallationRepositoryResult.class);
    }

    private static class GHAppInstallationRepositoryResult
    extends SearchResult<GHRepository> {
        private GHRepository[] repositories;

        private GHAppInstallationRepositoryResult() {
        }

        GHRepository[] getItems(GitHub root) {
            return this.repositories;
        }
    }
}

