/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Poster {
    private final GitHub root;
    private final List<String> args = new ArrayList<String>();
    private boolean authenticate;

    Poster(GitHub root) {
        this.root = root;
    }

    public Poster withCredential() {
        this.root.requireCredential();
        this.authenticate = true;
        return this;
    }

    public Poster with(String key, int value) {
        return this.with(key, String.valueOf(value));
    }

    public Poster with(String key, String value) {
        if (value != null) {
            try {
                this.args.add(URLEncoder.encode(key, "UTF-8") + '=' + URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this.to(tailApiUrl, type, "POST");
    }

    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        while (true) {
            HttpURLConnection uc = (HttpURLConnection)this.root.getApiURL(tailApiUrl).openConnection();
            uc.setDoOutput(true);
            uc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            if (this.authenticate) {
                uc.setRequestProperty("Authorization", "Basic " + this.root.encodedAuthorization);
            }
            uc.setRequestMethod(method);
            StringBuilder body = new StringBuilder();
            for (String e : this.args) {
                if (body.length() > 0) {
                    body.append('&');
                }
                body.append(e);
            }
            OutputStreamWriter o = new OutputStreamWriter(uc.getOutputStream(), "UTF-8");
            o.write(body.toString());
            o.close();
            try {
                InputStreamReader r = new InputStreamReader(uc.getInputStream(), "UTF-8");
                if (type == null) {
                    String data = IOUtils.toString((Reader)r);
                    return null;
                }
                return (T)GitHub.MAPPER.readValue((Reader)r, type);
            }
            catch (IOException e) {
                this.root.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }
}

