/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHUser
extends GHPerson {
    public void follow() throws IOException {
        new Requester(this.root).method("PUT").to("/user/following/" + this.login);
    }

    public void unfollow() throws IOException {
        new Requester(this.root).method("DELETE").to("/user/following/" + this.login);
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollows() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listFollows().asList());
    }

    public PagedIterable<GHUser> listFollows() {
        return this.listUser("following");
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getFollowers() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listFollowers().asList());
    }

    public PagedIterable<GHUser> listFollowers() {
        return this.listUser("followers");
    }

    private PagedIterable<GHUser> listUser(final String suffix) {
        return new PagedIterable<GHUser>(){

            @Override
            public PagedIterator<GHUser> _iterator(int pageSize) {
                return new PagedIterator<GHUser>(GHUser.this.root.retrieve().asIterator(GHUser.this.getApiTailUrl(suffix), GHUser[].class, pageSize)){

                    protected void wrapUp(GHUser[] page) {
                        GHUser.wrap(page, GHUser.this.root);
                    }
                };
            }
        };
    }

    public PagedIterable<GHRepository> listSubscriptions() {
        return this.listRepositories("subscriptions");
    }

    public PagedIterable<GHRepository> listStarredRepositories() {
        return this.listRepositories("starred");
    }

    private PagedIterable<GHRepository> listRepositories(final String suffix) {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> _iterator(int pageSize) {
                return new PagedIterator<GHRepository>(GHUser.this.root.retrieve().asIterator(GHUser.this.getApiTailUrl(suffix), GHRepository[].class, pageSize)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository c : page) {
                            c.wrap(GHUser.this.root);
                        }
                    }
                };
            }
        };
    }

    public boolean isMemberOf(GHOrganization org) {
        return org.hasMember(this);
    }

    public boolean isMemberOf(GHTeam team) {
        return team.hasMember(this);
    }

    public boolean isPublicMemberOf(GHOrganization org) {
        return org.hasPublicMember(this);
    }

    static GHUser[] wrap(GHUser[] users, GitHub root) {
        for (GHUser f : users) {
            f.root = root;
        }
        return users;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHOrganization> getOrganizations() throws IOException {
        GHPersonSet<GHOrganization> orgs = new GHPersonSet<GHOrganization>();
        HashSet<String> names = new HashSet<String>();
        for (GHOrganization o : (GHOrganization[])this.root.retrieve().to("/users/" + this.login + "/orgs", GHOrganization[].class)) {
            if (!names.add(o.getLogin())) continue;
            orgs.add(this.root.getOrganization(o.getLogin()));
        }
        return orgs;
    }

    @Override
    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return new PagedIterable<GHEventInfo>(){

            @Override
            public PagedIterator<GHEventInfo> _iterator(int pageSize) {
                return new PagedIterator<GHEventInfo>(GHUser.this.root.retrieve().asIterator(String.format("/users/%s/events", GHUser.this.login), GHEventInfo[].class, pageSize)){

                    protected void wrapUp(GHEventInfo[] page) {
                        for (GHEventInfo c : page) {
                            c.wrapUp(GHUser.this.root);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHGist> listGists() throws IOException {
        return new PagedIterable<GHGist>(){

            @Override
            public PagedIterator<GHGist> _iterator(int pageSize) {
                return new PagedIterator<GHGist>(GHUser.this.root.retrieve().asIterator(String.format("/users/%s/gists", GHUser.this.login), GHGist[].class, pageSize)){

                    protected void wrapUp(GHGist[] page) {
                        for (GHGist c : page) {
                            c.wrapUp(GHUser.this);
                        }
                    }
                };
            }
        };
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }

    String getApiTailUrl(String tail) {
        if (tail.length() > 0 && !tail.startsWith("/")) {
            tail = '/' + tail;
        }
        return "/users/" + this.login + tail;
    }

    @Override
    GHUser wrapUp(GitHub root) {
        super.wrapUp(root);
        return this;
    }
}

