/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GHPerson
extends GHObject {
    GitHub root;
    protected String login;
    protected String avatar_url;
    protected String gravatar_id;
    protected String location;
    protected String blog;
    protected String email;
    protected String name;
    protected String company;
    protected String html_url;
    protected int followers;
    protected int following;
    protected int public_repos;
    protected int public_gists;

    GHPerson wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    protected synchronized void populate() throws IOException {
        if (this.created_at != null) {
            return;
        }
        this.root.retrieve().to(this.url, this);
    }

    public synchronized Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories()) {
            repositories.put(r.getName(), r);
        }
        return Collections.unmodifiableMap(repositories);
    }

    public PagedIterable<GHRepository> listRepositories() {
        return this.listRepositories(30);
    }

    public PagedIterable<GHRepository> listRepositories(int pageSize) {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> _iterator(int pageSize) {
                return new PagedIterator<GHRepository>(GHPerson.this.root.retrieve().asIterator("/users/" + GHPerson.this.login + "/repos?per_page=" + pageSize, GHRepository[].class, pageSize)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository c : page) {
                            c.wrap(GHPerson.this.root);
                        }
                    }
                };
            }
        };
    }

    public synchronized Iterable<List<GHRepository>> iterateRepositories(final int pageSize) {
        return new Iterable<List<GHRepository>>(){

            @Override
            public Iterator<List<GHRepository>> iterator() {
                final Iterator<GHRepository[]> pager = GHPerson.this.root.retrieve().asIterator("/users/" + GHPerson.this.login + "/repos?per_page=" + pageSize, GHRepository[].class, pageSize);
                return new Iterator<List<GHRepository>>(){

                    @Override
                    public boolean hasNext() {
                        return pager.hasNext();
                    }

                    @Override
                    public List<GHRepository> next() {
                        GHRepository[] batch;
                        for (GHRepository r : batch = (GHRepository[])pager.next()) {
                            r.root = GHPerson.this.root;
                        }
                        return Arrays.asList(batch);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public GHRepository getRepository(String name) throws IOException {
        try {
            return ((GHRepository)((Object)this.root.retrieve().to("/repos/" + this.login + '/' + name, GHRepository.class))).wrap(this.root);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public abstract PagedIterable<GHEventInfo> listEvents() throws IOException;

    public String getGravatarId() {
        return this.gravatar_id;
    }

    public String getAvatarUrl() {
        if (this.avatar_url != null) {
            return this.avatar_url;
        }
        if (this.gravatar_id != null) {
            return "https://secure.gravatar.com/avatar/" + this.gravatar_id;
        }
        return null;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() throws IOException {
        this.populate();
        return this.name;
    }

    public String getCompany() throws IOException {
        this.populate();
        return this.company;
    }

    public String getLocation() throws IOException {
        this.populate();
        return this.location;
    }

    @Override
    public Date getCreatedAt() throws IOException {
        this.populate();
        return super.getCreatedAt();
    }

    @Override
    public Date getUpdatedAt() throws IOException {
        this.populate();
        return super.getCreatedAt();
    }

    public String getBlog() throws IOException {
        this.populate();
        return this.blog;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getEmail() throws IOException {
        this.populate();
        return this.email;
    }

    public int getPublicGistCount() throws IOException {
        this.populate();
        return this.public_gists;
    }

    public int getPublicRepoCount() throws IOException {
        this.populate();
        return this.public_repos;
    }

    public int getFollowingCount() throws IOException {
        this.populate();
        return this.following;
    }

    public int getFollowersCount() throws IOException {
        this.populate();
        return this.followers;
    }
}

