/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GHSearchBuilder<T> {
    protected final GitHub root;
    protected final Requester req;
    protected final List<String> terms = new ArrayList<String>();
    private final Class<? extends SearchResult<T>> receiverType;

    GHSearchBuilder(GitHub root, Class<? extends SearchResult<T>> receiverType) {
        this.root = root;
        this.req = root.retrieve();
        this.receiverType = receiverType;
    }

    public GHSearchBuilder q(String term) {
        this.terms.add(term);
        return this;
    }

    public PagedSearchIterable<T> list() {
        return new PagedSearchIterable<T>(this.root){

            @Override
            public PagedIterator<T> iterator() {
                GHSearchBuilder.this.req.set("q", StringUtils.join(GHSearchBuilder.this.terms, (String)" "));
                return new PagedIterator<T>(this.adapt(GHSearchBuilder.this.req.asIterator(GHSearchBuilder.this.getApiUrl(), GHSearchBuilder.this.receiverType))){

                    @Override
                    protected void wrapUp(T[] page) {
                    }
                };
            }
        };
    }

    protected abstract String getApiUrl();
}

