/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHContentSearchBuilder;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GHGistBuilder;
import org.kohsuke.github.GHIssueSearchBuilder;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositorySearchBuilder;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHUserSearchBuilder;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GitHub {
    final String login;
    final String encodedAuthorization;
    private final Map<String, GHUser> users = new Hashtable<String, GHUser>();
    private final Map<String, GHOrganization> orgs = new Hashtable<String, GHOrganization>();
    private final String apiUrl;
    final RateLimitHandler rateLimitHandler;
    private HttpConnector connector = HttpConnector.DEFAULT;
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
    static final String GITHUB_URL = "https://api.github.com";

    GitHub(String apiUrl, String login, String oauthAccessToken, String password, HttpConnector connector, RateLimitHandler rateLimitHandler) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        this.apiUrl = apiUrl;
        if (null != connector) {
            this.connector = connector;
        }
        if (oauthAccessToken != null) {
            this.encodedAuthorization = "token " + oauthAccessToken;
        } else if (password != null) {
            Charset charset;
            String authorization = login + ':' + password;
            try {
                charset = Charset.forName("UTF-8");
            }
            catch (Exception ex) {
                throw new IOException("UTF-8 encoding is not supported", ex);
            }
            this.encodedAuthorization = "Basic " + new String(Base64.encodeBase64((byte[])authorization.getBytes(charset)), charset);
        } else {
            this.encodedAuthorization = null;
        }
        this.rateLimitHandler = rateLimitHandler;
        if (login == null && this.encodedAuthorization != null) {
            login = this.getMyself().getLogin();
        }
        this.login = login;
    }

    public static GitHub connect() throws IOException {
        return GitHubBuilder.fromCredentials().build();
    }

    public static GitHub connectToEnterprise(String apiUrl, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectToEnterprise(String apiUrl, String login, String password) throws IOException {
        return new GitHubBuilder().withEndpoint(apiUrl).withPassword(login, password).build();
    }

    public static GitHub connect(String login, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).build();
    }

    public static GitHub connect(String login, String oauthAccessToken, String password) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken, login).withPassword(login, password).build();
    }

    public static GitHub connectUsingPassword(String login, String password) throws IOException {
        return new GitHubBuilder().withPassword(login, password).build();
    }

    public static GitHub connectUsingOAuth(String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectUsingOAuth(String githubServer, String oauthAccessToken) throws IOException {
        return new GitHubBuilder().withEndpoint(githubServer).withOAuthToken(oauthAccessToken).build();
    }

    public static GitHub connectAnonymously() throws IOException {
        return new GitHubBuilder().build();
    }

    public boolean isAnonymous() {
        return this.login == null && this.encodedAuthorization == null;
    }

    public HttpConnector getConnector() {
        return this.connector;
    }

    public void setConnector(HttpConnector connector) {
        this.connector = connector;
    }

    void requireCredential() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tailApiUrl) throws IOException {
        if (tailApiUrl.startsWith("/")) {
            if ("github.com".equals(this.apiUrl)) {
                return new URL(GITHUB_URL + tailApiUrl);
            }
            return new URL(this.apiUrl + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    Requester retrieve() {
        return new Requester(this).method("GET");
    }

    public GHRateLimit getRateLimit() throws IOException {
        try {
            return ((JsonRateLimit)((Object)this.retrieve().to((String)"/rate_limit", JsonRateLimit.class))).rate;
        }
        catch (FileNotFoundException e) {
            GHRateLimit r = new GHRateLimit();
            r.remaining = 1000000;
            r.limit = 1000000;
            r.reset = new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L));
            return r;
        }
    }

    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.requireCredential();
        GHMyself u = (GHMyself)((Object)this.retrieve().to("/user", GHMyself.class));
        u.root = this;
        this.users.put(u.getLogin(), u);
        return u;
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = (GHUser)((Object)this.retrieve().to("/users/" + login, GHUser.class));
            u.root = this;
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    public void refreshCache() {
        this.users.clear();
        this.orgs.clear();
    }

    protected GHUser getUser(GHUser orig) throws IOException {
        GHUser u = this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(orig.getLogin(), orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = this.orgs.get(name);
        if (o == null) {
            o = ((GHOrganization)((Object)this.retrieve().to("/orgs/" + name, GHOrganization.class))).wrapUp(this);
            this.orgs.put(name, o);
        }
        return o;
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        return ((GHRepository)((Object)this.retrieve().to("/repos/" + tokens[0] + '/' + tokens[1], GHRepository.class))).wrap(this);
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        GHOrganization[] orgs = (GHOrganization[])this.retrieve().to("/user/orgs", GHOrganization[].class);
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o.wrapUp(this));
        }
        return r;
    }

    public Map<String, Set<GHTeam>> getMyTeams() throws IOException {
        HashMap<String, Set<GHTeam>> allMyTeams = new HashMap<String, Set<GHTeam>>();
        for (GHTeam team : (GHTeam[])this.retrieve().to("/user/teams", GHTeam[].class)) {
            team.wrapUp(this);
            String orgLogin = team.getOrganization().getLogin();
            HashSet<GHTeam> teamsPerOrg = (HashSet<GHTeam>)allMyTeams.get(orgLogin);
            if (teamsPerOrg == null) {
                teamsPerOrg = new HashSet<GHTeam>();
            }
            teamsPerOrg.add(team);
            allMyTeams.put(orgLogin, teamsPerOrg);
        }
        return allMyTeams;
    }

    public List<GHEventInfo> getEvents() throws IOException {
        GHEventInfo[] events;
        for (GHEventInfo e : events = (GHEventInfo[])this.retrieve().to("/events", GHEventInfo[].class)) {
            e.wrapUp(this);
        }
        return Arrays.asList(events);
    }

    public GHGist getGist(String id) throws IOException {
        return ((GHGist)((Object)this.retrieve().to("/gists/" + id, GHGist.class))).wrapUp(this);
    }

    public GHGistBuilder createGist() {
        return new GHGistBuilder(this);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)MAPPER.readValue(r, type);
        t.wrapUp(this);
        return (T)t;
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        Requester requester = new Requester(this).with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic ? 1 : 0);
        return ((GHRepository)((Object)requester.method("POST").to("/user/repos", GHRepository.class))).wrap(this);
    }

    public GHAuthorization createToken(Collection<String> scope, String note, String noteUrl) throws IOException {
        Requester requester = new Requester(this).with("scopes", scope).with("note", note).with("note_url", noteUrl);
        return ((GHAuthorization)((Object)requester.method("POST").to("/authorizations", GHAuthorization.class))).wrap(this);
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieve().to("/user", GHUser.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public GHIssueSearchBuilder searchIssues() {
        return new GHIssueSearchBuilder(this);
    }

    public GHUserSearchBuilder searchUsers() {
        return new GHUserSearchBuilder(this);
    }

    public GHRepositorySearchBuilder searchRepositories() {
        return new GHRepositorySearchBuilder(this);
    }

    public GHContentSearchBuilder searchContent() {
        return new GHContentSearchBuilder(this);
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this, "/notifications");
    }

    public PagedIterable<GHRepository> listAllPublicRepositories() {
        return this.listAllPublicRepositories(null);
    }

    public PagedIterable<GHRepository> listAllPublicRepositories(final String since) {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> iterator() {
                return new PagedIterator<GHRepository>(GitHub.this.retrieve().with("since", since).asIterator("/repositories", GHRepository[].class)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository c : page) {
                            c.wrap(GitHub.this);
                        }
                    }
                };
            }
        };
    }

    public Reader renderMarkdown(String text) throws IOException {
        return new InputStreamReader(new Requester(this).with(new ByteArrayInputStream(text.getBytes("UTF-8"))).contentType("text/plain;charset=UTF-8").asStream("/markdown/raw"), "UTF-8");
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static String printDate(Date dt) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(dt);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

