/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHRelease
extends GHObject {
    GitHub root;
    GHRepository owner;
    private String html_url;
    private String assets_url;
    private String upload_url;
    private String tag_name;
    private String target_commitish;
    private String name;
    private String body;
    private boolean draft;
    private boolean prerelease;
    private Date published_at;
    private String tarball_url;
    private String zipball_url;

    public String getAssetsUrl() {
        return this.assets_url;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public GHRelease setDraft(boolean draft) throws IOException {
        this.edit("draft", draft);
        this.draft = draft;
        return this;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public void setOwner(GHRepository owner) {
        this.owner = owner;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public Date getPublished_at() {
        return new Date(this.published_at.getTime());
    }

    public GitHub getRoot() {
        return this.root;
    }

    public String getTagName() {
        return this.tag_name;
    }

    public String getTargetCommitish() {
        return this.target_commitish;
    }

    public String getUploadUrl() {
        return this.upload_url;
    }

    public String getZipballUrl() {
        return this.zipball_url;
    }

    public String getTarballUrl() {
        return this.tarball_url;
    }

    GHRelease wrap(GHRepository owner) {
        this.owner = owner;
        this.root = owner.root;
        return this;
    }

    static GHRelease[] wrap(GHRelease[] releases, GHRepository owner) {
        for (GHRelease release : releases) {
            release.wrap(owner);
        }
        return releases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHAsset uploadAsset(File file, String contentType) throws IOException {
        Requester builder = new Requester(this.owner.root);
        String url = String.format("https://uploads.github.com%s/releases/%d/assets?name=%s", this.owner.getApiTailUrl(""), this.getId(), file.getName());
        FileInputStream istream = new FileInputStream(file);
        try {
            GHAsset gHAsset = ((GHAsset)((Object)builder.contentType(contentType).with(istream).to(url, GHAsset.class))).wrap(this);
            return gHAsset;
        }
        finally {
            istream.close();
        }
    }

    public List<GHAsset> getAssets() throws IOException {
        Requester builder = new Requester(this.owner.root);
        GHAsset[] assets = (GHAsset[])builder.method("GET").to(this.getApiTailUrl("assets"), GHAsset[].class);
        return Arrays.asList(GHAsset.wrap(assets, this));
    }

    public void delete() throws IOException {
        new Requester(this.root).method("DELETE").to(this.owner.getApiTailUrl("releases/" + this.id));
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.owner.getApiTailUrl("releases/" + this.id));
    }

    private String getApiTailUrl(String end) {
        return this.owner.getApiTailUrl(String.format("releases/%s/%s", this.id, end));
    }
}

