/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Requester {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String method = "POST";
    private String contentType = "application/x-www-form-urlencoded";
    private InputStream body;
    private HttpURLConnection uc;

    Requester(GitHub root) {
        this.root = root;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Deprecated
    public Requester withCredential() {
        return this;
    }

    public Requester with(String key, int value) {
        return this._with(key, value);
    }

    public Requester with(String key, Integer value) {
        if (value != null) {
            this._with(key, (int)value);
        }
        return this;
    }

    public Requester with(String key, boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, Boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, String value) {
        return this._with(key, value);
    }

    public Requester with(String key, Collection<String> value) {
        return this._with(key, value);
    }

    public Requester with(String key, Map<String, String> value) {
        return this._with(key, value);
    }

    public Requester with(InputStream body) {
        this.body = body;
        return this;
    }

    public Requester _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public Requester set(String key, Object value) {
        for (Entry e : this.args) {
            if (!e.key.equals(key)) continue;
            e.value = value;
            return this;
        }
        return this._with(key, value);
    }

    public Requester method(String method) {
        this.method = method;
        return this;
    }

    public Requester contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, (Object)null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this._to(tailApiUrl, type, null);
    }

    public <T> T to(String tailApiUrl, T existingInstance) throws IOException {
        return this._to(tailApiUrl, null, existingInstance);
    }

    @Deprecated
    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        return (T)this.method(method).to(tailApiUrl, (T)type);
    }

    private <T> T _to(String tailApiUrl, Class<T> type, T instance) throws IOException {
        while (true) {
            if (this.method.equals("GET") && !this.args.isEmpty()) {
                StringBuilder qs = new StringBuilder();
                for (Entry arg : this.args) {
                    qs.append(qs.length() == 0 ? (char)'?' : '&');
                    qs.append(arg.key).append('=').append(URLEncoder.encode(arg.value.toString(), "UTF-8"));
                }
                tailApiUrl = tailApiUrl + qs.toString();
            }
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                Pattern nextLinkPattern;
                Matcher nextLinkMatcher;
                String links;
                Object result = this.parse(type, instance);
                if (type != null && type.isArray() && (links = this.uc.getHeaderField("link")) != null && links.contains("rel=\"next\"") && (nextLinkMatcher = (nextLinkPattern = Pattern.compile(".*<(.*)>; rel=\"next\"")).matcher(links)).find()) {
                    String link = nextLinkMatcher.group(1);
                    T nextResult = this._to(link, type, instance);
                    int resultLength = Array.getLength(result);
                    int nextResultLength = Array.getLength(nextResult);
                    Object concatResult = Array.newInstance(type.getComponentType(), resultLength + nextResultLength);
                    System.arraycopy(result, 0, concatResult, 0, resultLength);
                    System.arraycopy(nextResult, 0, concatResult, resultLength, nextResultLength);
                    result = concatResult;
                }
                return result;
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            break;
        }
    }

    public int asHttpStatusCode(String tailApiUrl) throws IOException {
        while (true) {
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                return this.uc.getResponseCode();
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            break;
        }
    }

    public InputStream asStream(String tailApiUrl) throws IOException {
        while (true) {
            this.setupConnection(this.root.getApiURL(tailApiUrl));
            this.buildRequest();
            try {
                return this.wrapStream(this.uc.getInputStream());
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            break;
        }
    }

    public String getResponseHeader(String header) {
        return this.uc.getHeaderField(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRequest() throws IOException {
        if (!this.method.equals("GET")) {
            this.uc.setDoOutput(true);
            this.uc.setRequestProperty("Content-type", this.contentType);
            if (this.body == null) {
                HashMap<String, Object> json = new HashMap<String, Object>();
                for (Entry e : this.args) {
                    json.put(e.key, e.value);
                }
                GitHub.MAPPER.writeValue(this.uc.getOutputStream(), json);
            } else {
                try {
                    byte[] bytes = new byte[32768];
                    int read = 0;
                    while ((read = this.body.read(bytes)) != -1) {
                        this.uc.getOutputStream().write(bytes, 0, read);
                    }
                }
                finally {
                    this.body.close();
                }
            }
        }
    }

    <T> Iterator<T> asIterator(String _tailApiUrl, final Class<T> type) {
        this.method("GET");
        if (!this.args.isEmpty()) {
            boolean first = true;
            try {
                for (Entry a : this.args) {
                    _tailApiUrl = _tailApiUrl + (first ? (char)'?' : '&');
                    first = false;
                    _tailApiUrl = _tailApiUrl + URLEncoder.encode(a.key, "UTF-8") + '=' + URLEncoder.encode(a.value.toString(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        final String tailApiUrl = _tailApiUrl;
        return new Iterator<T>(){
            T next;
            URL url;
            {
                try {
                    this.url = Requester.this.root.getApiURL(tailApiUrl);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object r = this.next;
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    while (true) {
                        Requester.this.setupConnection(this.url);
                        try {
                            this.next = Requester.this.parse(type, null);
                            assert (this.next != null);
                            this.findNextURL();
                            return;
                        }
                        catch (IOException e) {
                            Requester.this.handleApiError(e);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextURL() throws MalformedURLException {
                this.url = null;
                String link = Requester.this.uc.getHeaderField("Link");
                if (link == null) {
                    return;
                }
                for (String token : link.split(", ")) {
                    if (!token.endsWith("rel=\"next\"")) continue;
                    int idx = token.indexOf(62);
                    this.url = new URL(token.substring(1, idx));
                    return;
                }
            }
        };
    }

    private void setupConnection(URL url) throws IOException {
        this.uc = this.root.getConnector().connect(url);
        if (this.root.encodedAuthorization != null) {
            this.uc.setRequestProperty("Authorization", this.root.encodedAuthorization);
        }
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            String v = e.getValue();
            if (v == null) continue;
            this.uc.setRequestProperty(e.getKey(), v);
        }
        try {
            this.uc.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(this.uc, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        this.uc.setRequestProperty("Accept-Encoding", "gzip");
    }

    /*
     * Exception decompiling
     */
    private <T> T parse(Class<T> type, T instance) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream wrapStream(InputStream in) throws IOException {
        String encoding = this.uc.getContentEncoding();
        if (encoding == null || in == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    void handleApiError(IOException e) throws IOException {
        if (this.uc.getResponseCode() == 401) {
            throw e;
        }
        if ("0".equals(this.uc.getHeaderField("X-RateLimit-Remaining"))) {
            this.root.rateLimitHandler.onError(e, this.uc);
        }
        InputStream es = this.wrapStream(this.uc.getErrorStream());
        try {
            if (es != null) {
                if (e instanceof FileNotFoundException) {
                    throw (IOException)new FileNotFoundException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
                }
                throw (IOException)new IOException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    private Set<String> toSet(String s) {
        HashSet<String> r = new HashSet<String>();
        for (String t : s.split(",")) {
            r.add(t.trim());
        }
        return r;
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

