/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Locale;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHIssueSearchBuilder
extends GHSearchBuilder<GHIssue> {
    GHIssueSearchBuilder(GitHub root) {
        super(root, IssueSearchResult.class);
    }

    @Override
    public GHIssueSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHIssueSearchBuilder mentions(GHUser u) {
        return this.mentions(u.getLogin());
    }

    public GHIssueSearchBuilder mentions(String login) {
        return this.q("mentions:" + login);
    }

    public GHIssueSearchBuilder isOpen() {
        return this.q("is:open");
    }

    public GHIssueSearchBuilder isClosed() {
        return this.q("is:closed");
    }

    public GHIssueSearchBuilder isMerged() {
        return this.q("is:merged");
    }

    public GHIssueSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort.toString().toLowerCase(Locale.ENGLISH));
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/issues";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IssueSearchResult
    extends SearchResult<GHIssue> {
        private GHIssue[] items;

        private IssueSearchResult() {
        }

        GHIssue[] getItems(GitHub root) {
            for (GHIssue i : this.items) {
                i.wrap(root);
            }
            return this.items;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        COMMENTS,
        CREATED,
        UPDATED;

    }
}

