/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHContent {
    private GHRepository owner;
    private String type;
    private String encoding;
    private long size;
    private String sha;
    private String name;
    private String path;
    private String content;
    private String url;
    private String git_url;
    private String html_url;

    public GHRepository getOwner() {
        return this.owner;
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getSize() {
        return this.size;
    }

    public String getSha() {
        return this.sha;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() throws IOException {
        return new String(DatatypeConverter.parseBase64Binary((String)this.getEncodedContent()));
    }

    public String getEncodedContent() throws IOException {
        if (this.content != null) {
            return this.content;
        }
        GHContent retrievedContent = this.owner.getFileContent(this.path);
        this.size = retrievedContent.size;
        this.sha = retrievedContent.sha;
        this.content = retrievedContent.content;
        this.url = retrievedContent.url;
        this.git_url = retrievedContent.git_url;
        this.html_url = retrievedContent.html_url;
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public String getGitUrl() {
        return this.git_url;
    }

    public String getHtmlUrl() {
        return this.html_url;
    }

    public boolean isFile() {
        return "file".equals(this.type);
    }

    public boolean isDirectory() {
        return "dir".equals(this.type);
    }

    public PagedIterable<GHContent> listDirectoryContent() throws IOException {
        if (!this.isDirectory()) {
            throw new IllegalStateException(this.path + " is not a directory");
        }
        return new PagedIterable<GHContent>(){

            @Override
            public PagedIterator<GHContent> iterator() {
                return new PagedIterator<GHContent>(((GHContent)GHContent.this).owner.root.retrieve().asIterator(GHContent.this.url, GHContent[].class)){

                    protected void wrapUp(GHContent[] page) {
                        GHContent.wrap(page, GHContent.this.owner);
                    }
                };
            }
        };
    }

    public GHContentUpdateResponse update(String newContent, String commitMessage) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, null);
    }

    public GHContentUpdateResponse update(String newContent, String commitMessage, String branch) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, branch);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage) throws IOException {
        return this.update(newContentBytes, commitMessage, null);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage, String branch) throws IOException {
        String encodedContent = DatatypeConverter.printBase64Binary((byte[])newContentBytes);
        Requester requester = new Requester(this.owner.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).with("content", encodedContent).method("PUT");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(this.getApiRoute(), GHContentUpdateResponse.class));
        response.getContent().wrap(this.owner);
        response.getCommit().wrapUp(this.owner);
        this.content = encodedContent;
        return response;
    }

    public GHContentUpdateResponse delete(String message) throws IOException {
        return this.delete(message, null);
    }

    public GHContentUpdateResponse delete(String commitMessage, String branch) throws IOException {
        Requester requester = new Requester(this.owner.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).method("DELETE");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(this.getApiRoute(), GHContentUpdateResponse.class));
        response.getCommit().wrapUp(this.owner);
        return response;
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/contents/" + this.path;
    }

    GHContent wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    public static GHContent[] wrap(GHContent[] contents, GHRepository repository) {
        for (GHContent unwrappedContent : contents) {
            unwrappedContent.wrap(repository);
        }
        return contents;
    }
}

