/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHRelease {
    GitHub root;
    GHRepository owner;
    private String url;
    private String html_url;
    private String assets_url;
    private String upload_url;
    private long id;
    private String tag_name;
    private String target_commitish;
    private String name;
    private String body;
    private boolean draft;
    private boolean prerelease;
    private Date created_at;
    private Date published_at;

    public String getAssetsUrl() {
        return this.assets_url;
    }

    public void setAssetsUrl(String assets_url) {
        this.assets_url = assets_url;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Date getCreatedAt() {
        return this.created_at;
    }

    public void setCreatedAt(Date created_at) {
        this.created_at = created_at;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public String getHtmlUrl() {
        return this.html_url;
    }

    public void setHtmlUrl(String html_url) {
        this.html_url = html_url;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public void setOwner(GHRepository owner) {
        this.owner = owner;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public void setPrerelease(boolean prerelease) {
        this.prerelease = prerelease;
    }

    public Date getPublished_at() {
        return this.published_at;
    }

    public void setPublished_at(Date published_at) {
        this.published_at = published_at;
    }

    public GitHub getRoot() {
        return this.root;
    }

    public void setRoot(GitHub root) {
        this.root = root;
    }

    public String getTagName() {
        return this.tag_name;
    }

    public void setTagName(String tag_name) {
        this.tag_name = tag_name;
    }

    public String getTargetCommitish() {
        return this.target_commitish;
    }

    public void setTargetCommitish(String target_commitish) {
        this.target_commitish = target_commitish;
    }

    public String getUploadUrl() {
        return this.upload_url;
    }

    public void setUploadUrl(String upload_url) {
        this.upload_url = upload_url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    GHRelease wrap(GHRepository owner) {
        this.owner = owner;
        this.root = owner.root;
        return this;
    }

    static GHRelease[] wrap(GHRelease[] releases, GHRepository owner) {
        for (GHRelease release : releases) {
            release.wrap(owner);
        }
        return releases;
    }

    public GHAsset uploadAsset(File file, String contentType) throws IOException {
        Requester builder = new Requester(this.owner.root);
        String url = String.format("https://uploads.github.com%sreleases/%d/assets?name=%s", this.owner.getApiTailUrl(""), this.getId(), file.getName());
        return ((GHAsset)((Object)builder.contentType(contentType).with(new FileInputStream(file)).to(url, GHAsset.class))).wrap(this);
    }

    public List<GHAsset> getAssets() throws IOException {
        Requester builder = new Requester(this.owner.root);
        GHAsset[] assets = (GHAsset[])builder.method("GET").to(this.owner.getApiTailUrl(String.format("releases/%d/assets", this.id)), GHAsset[].class);
        return Arrays.asList(GHAsset.wrap(assets, this));
    }
}

