/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.kohsuke.github.GHAuthorization;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GitHub {
    final String login;
    final String encodedAuthorization;
    private final Map<String, GHUser> users = new HashMap<String, GHUser>();
    private final Map<String, GHOrganization> orgs = new HashMap<String, GHOrganization>();
    private final String apiUrl;
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
    private static final String GITHUB_URL = "https://api.github.com";

    private GitHub(String login, String oauthAccessToken, String password) throws IOException {
        this(GITHUB_URL, login, oauthAccessToken, password);
    }

    private GitHub(String apiUrl, String login, String oauthAccessToken, String password) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        this.apiUrl = apiUrl;
        if (oauthAccessToken != null) {
            this.encodedAuthorization = "token " + oauthAccessToken;
        } else if (password != null) {
            String authorization = login + ':' + password;
            this.encodedAuthorization = "Basic " + new String(Base64.encodeBase64((byte[])authorization.getBytes()));
        } else {
            this.encodedAuthorization = null;
        }
        if (login == null && this.encodedAuthorization != null) {
            login = this.getMyself().getLogin();
        }
        this.login = login;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHub connect() throws IOException {
        Properties props = new Properties();
        File homeDir = new File(System.getProperty("user.home"));
        FileInputStream in = new FileInputStream(new File(homeDir, ".github"));
        try {
            props.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new GitHub(GITHUB_URL, props.getProperty("login"), props.getProperty("oauth"), props.getProperty("password"));
    }

    public static GitHub connectToEnterprise(String apiUrl, String oauthAccessToken) throws IOException {
        return GitHub.connectUsingOAuth(apiUrl, oauthAccessToken);
    }

    public static GitHub connectToEnterprise(String apiUrl, String login, String password) throws IOException {
        return new GitHub(apiUrl, login, null, password);
    }

    public static GitHub connect(String login, String oauthAccessToken) throws IOException {
        return new GitHub(login, oauthAccessToken, null);
    }

    public static GitHub connect(String login, String oauthAccessToken, String password) throws IOException {
        return new GitHub(login, oauthAccessToken, password);
    }

    public static GitHub connectUsingPassword(String login, String password) throws IOException {
        return new GitHub(login, null, password);
    }

    public static GitHub connectUsingOAuth(String oauthAccessToken) throws IOException {
        return new GitHub(null, oauthAccessToken, null);
    }

    public static GitHub connectUsingOAuth(String githubServer, String oauthAccessToken) throws IOException {
        return new GitHub(githubServer, null, oauthAccessToken, null);
    }

    public static GitHub connectAnonymously() throws IOException {
        return new GitHub(null, null, null);
    }

    void requireCredential() {
        if (this.login == null && this.encodedAuthorization == null) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tailApiUrl) throws IOException {
        if (tailApiUrl.startsWith("/")) {
            if ("github.com".equals(this.apiUrl)) {
                return new URL(GITHUB_URL + tailApiUrl);
            }
            return new URL(this.apiUrl + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    Requester retrieve() {
        return new Requester(this).method("GET");
    }

    public GHRateLimit getRateLimit() throws IOException {
        return ((JsonRateLimit)((Object)this.retrieve().to((String)"/rate_limit", JsonRateLimit.class))).rate;
    }

    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.requireCredential();
        GHMyself u = (GHMyself)((Object)this.retrieve().to("/user", GHMyself.class));
        u.root = this;
        this.users.put(u.getLogin(), u);
        return u;
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = (GHUser)((Object)this.retrieve().to("/users/" + login, GHUser.class));
            u.root = this;
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    protected GHUser getUser(GHUser orig) throws IOException {
        GHUser u = this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(this.login, orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = this.orgs.get(name);
        if (o == null) {
            o = ((GHOrganization)((Object)this.retrieve().to("/orgs/" + name, GHOrganization.class))).wrapUp(this);
            this.orgs.put(name, o);
        }
        return o;
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        return ((GHRepository)((Object)this.retrieve().to("/repos/" + tokens[0] + '/' + tokens[1], GHRepository.class))).wrap(this);
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        GHOrganization[] orgs = (GHOrganization[])this.retrieve().to("/user/orgs", GHOrganization[].class);
        HashMap<String, GHOrganization> r = new HashMap<String, GHOrganization>();
        for (GHOrganization o : orgs) {
            r.put(o.getLogin(), o.wrapUp(this));
        }
        return r;
    }

    public List<GHEventInfo> getEvents() throws IOException {
        GHEventInfo[] events;
        for (GHEventInfo e : events = (GHEventInfo[])this.retrieve().to("/events", GHEventInfo[].class)) {
            e.wrapUp(this);
        }
        return Arrays.asList(events);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)MAPPER.readValue(r, type);
        t.wrapUp(this);
        return (T)t;
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        Requester requester = new Requester(this).with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic ? 1 : 0);
        return ((GHRepository)((Object)requester.method("POST").to("/user/repos", GHRepository.class))).wrap(this);
    }

    public GHAuthorization createToken(Collection<String> scope, String note, String noteUrl) throws IOException {
        Requester requester = new Requester(this).with("scopes", scope).with("note", note).with("note_url", noteUrl);
        return ((GHAuthorization)((Object)requester.method("POST").to("/authorizations", GHAuthorization.class))).wrap(this);
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieve().to("/user", GHUser.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

