/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

public abstract class GHEventPayload {
    protected GitHub root;

    GHEventPayload() {
    }

    void wrapUp(GitHub root) {
        this.root = root;
    }

    public static class IssueComment
    extends GHEventPayload {
        private String action;
        private GHIssueComment comment;
        private GHIssue issue;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public GHIssueComment getComment() {
            return this.comment;
        }

        public void setComment(GHIssueComment comment) {
            this.comment = comment;
        }

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        void wrapUp(GitHub root) {
            super.wrapUp(root);
            this.repository.wrap(root);
            this.issue.wrap(this.repository);
            this.comment.wrapUp(this.issue);
        }
    }

    public static class PullRequest
    extends GHEventPayload {
        private String action;
        private int number;
        private GHPullRequest pull_request;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public int getNumber() {
            return this.number;
        }

        public GHPullRequest getPullRequest() {
            this.pull_request.root = this.root;
            return this.pull_request;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.repository != null) {
                this.repository.wrap(root);
                this.pull_request.wrap(this.repository);
            } else {
                this.pull_request.wrapUp(root);
            }
        }
    }
}

