/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHOrganization
extends GHPerson {
    @Override
    GHOrganization wrapUp(GitHub root) {
        return (GHOrganization)super.wrapUp(root);
    }

    public GHRepository createRepository(String name, String description, String homepage, String team, boolean isPublic) throws IOException {
        return this.createRepository(name, description, homepage, this.getTeams().get(team), isPublic);
    }

    public GHRepository createRepository(String name, String description, String homepage, GHTeam team, boolean isPublic) throws IOException {
        return ((GHRepository)((Object)new Requester(this.root).with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic).with("team_id", team.getId()).to("/orgs/" + this.login + "/repos", GHRepository.class))).wrap(this.root);
    }

    public Map<String, GHTeam> getTeams() throws IOException {
        GHTeam[] teams = (GHTeam[])this.root.retrieve().to("/orgs/" + this.login + "/teams", GHTeam[].class);
        TreeMap<String, GHTeam> r = new TreeMap<String, GHTeam>();
        for (GHTeam t : teams) {
            r.put(t.getName(), t.wrapUp(this));
        }
        return r;
    }

    public void publicize(GHUser u) throws IOException {
        this.root.retrieve().method("PUT").to("/orgs/" + this.login + "/public_members/" + u.getLogin(), null);
    }

    public List<GHUser> getMembers() throws IOException {
        return new AbstractList<GHUser>(){
            final GHUser[] shallow;
            {
                this.shallow = (GHUser[])GHOrganization.this.root.retrieve().to("/orgs/" + GHOrganization.this.login + "/members", GHUser[].class);
            }

            @Override
            public GHUser get(int index) {
                try {
                    return GHOrganization.this.root.getUser(this.shallow[index].getLogin());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int size() {
                return this.shallow.length;
            }
        };
    }

    public void conceal(GHUser u) throws IOException {
        this.root.retrieve().method("DELETE").to("/orgs/" + this.login + "/public_members/" + u.getLogin(), null);
    }

    public GHTeam createTeam(String name, Permission p, Collection<GHRepository> repositories) throws IOException {
        Requester post = new Requester(this.root).with("name", name).with("permission", p.name().toLowerCase());
        ArrayList<String> repo_names = new ArrayList<String>();
        for (GHRepository r : repositories) {
            repo_names.add(r.getName());
        }
        post.with("repo_names", repo_names);
        return ((GHTeam)((Object)post.method("POST").to("/orgs/" + this.login + "/teams", GHTeam.class))).wrapUp(this);
    }

    public GHTeam createTeam(String name, Permission p, GHRepository ... repositories) throws IOException {
        return this.createTeam(name, p, Arrays.asList(repositories));
    }

    public List<GHRepository> getRepositoriesWithOpenPullRequests() throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/organizations/" + this.login + "/dashboard/pulls");
        ArrayList<GHRepository> r = new ArrayList<GHRepository>();
        for (HtmlAnchor e : pg.getElementById("js-issue-list").selectNodes(".//UL[@class='smallnav']/LI[not(@class='zeroed')]/A")) {
            String a = e.getHrefAttribute();
            String name = a.substring(a.lastIndexOf(47) + 1);
            r.add(this.getRepository(name));
        }
        return r;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        ArrayList<GHPullRequest> all = new ArrayList<GHPullRequest>();
        for (GHRepository r : this.getRepositoriesWithOpenPullRequests()) {
            all.addAll(r.getPullRequests(GHIssueState.OPEN));
        }
        return all;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permission {
        ADMIN,
        PUSH,
        PULL;

    }
}

